// Copyright 1998 by Patrik Simons
// This software is provided as is, no warranty of any kind is given.
#ifndef READ_H
#define READ_H

#include "api.h"

class Atom;
class Program;

class Read
{
public:
  Read (Program *p);
  ~Read ();
  int read (istream &f);

  long models;

private:
  void grow ();
  Atom *getAtom (long n);
  int readBody (istream &f, long size, bool pos);
  int addBasicRule (istream &f);
  int addConstraintRule (istream &f);
  int addChoiceRule (istream &f);
  int addWeightRule (istream &f);
  int addOptimizeRule (istream &f);

  Atom **atoms;
  long size;
  long linenumber;
  Program * const program;
  Api api;
};

#endif
