// Copyright 1998,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#include "combi.h"

#ifndef UL_STACK_H
#define UL_STACK_H

#define UL_STACK_MINSIZE 16 /* A small power of two will do nicely */

typedef unsigned long UL_STACK_ELEMENT;

typedef struct ul_stack
{
  UL_STACK_ELEMENT *curr_sitem;     /* The current stack pointer */
  UL_STACK_ELEMENT *last_sitem;     /* The last item */
  UL_STACK_ELEMENT *sitems;
} UL_STACK;

#define ULStackEmpty(stack) \
(((stack)->curr_sitem == (&(stack)->sitems[0])) ? (TRUE) : (FALSE))

#define PushULStack(stack, i1) \
{ \
    *(stack)->curr_sitem = (UL_STACK_ELEMENT)(i1); \
    if((stack)->curr_sitem++ == (stack)->last_sitem) { \
      ExpandULStack(stack); \
    } \
}

/* Do NOT call the PeekULStack() macro when the stack is empty! */

#define PeekULStack(stack, i1) \
((i1) = (stack)->curr_sitem[-1])

/* Do NOT call the PopULStack() macro when the stack is empty! */

#define PopULStack(stack, i1) \
((stack)->curr_sitem--, \
 ((i1) = *(stack)->curr_sitem))

#define RemoveULStack(stack) \
((stack)->curr_sitem--, \
 *(stack)->curr_sitem)

#define ClearULStack(stack) \
((stack)->curr_sitem = (&(stack)->sitems[0]))


UL_STACK *CreateULStack(void);
void DeleteULStack(UL_STACK *stack);

/* For internal use only! */

void ExpandULStack(UL_STACK *stack);

#endif /* UL_STACK_H */
