// Copyright 1998,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#include "alloc.h"
#include "dassert.h"
#include "ulstack.h"

UL_STACK *CreateULStack(void)
{
  UL_STACK *stack;

  stack = (UL_STACK *)xmalloc(sizeof(UL_STACK));
  stack->sitems = (UL_STACK_ELEMENT *)xmalloc(UL_STACK_MINSIZE *
					      sizeof(UL_STACK_ELEMENT));

  stack->curr_sitem = &stack->sitems[0];
  stack->last_sitem = &stack->sitems[UL_STACK_MINSIZE -1];

  return stack;
}

void DeleteULStack(UL_STACK *stack)
{

  free(stack->sitems);
  free(stack);

}

void ExpandULStack(UL_STACK *stack)
{
  unsigned long curr;
  unsigned long new_size;

  // Double the new stacksize
  curr = (unsigned long)(stack->curr_sitem - &stack->sitems[0]);
  new_size = curr*2;

  stack->sitems = (UL_STACK_ELEMENT *)xrealloc(stack->sitems,
					       (new_size * 
						sizeof(UL_STACK_ELEMENT)));

  stack->curr_sitem = &stack->sitems[curr];
  stack->last_sitem = &stack->sitems[new_size -1];

}
