// Copyright 1998,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#include "combi.h"

#ifndef SARRAY_H
#define SARRAY_H

typedef unsigned long SARRAY_ELEMENT;

typedef struct SARRAY
{
  SARRAY_ELEMENT *curr_saitem;     /* The current sarray pointer */
  SARRAY_ELEMENT saitems[1];       /* This is actually larger */
} SARRAY;

#define SArrayEmpty(sarray) \
(((sarray)->curr_saitem == (&(sarray)->saitems[0])) ? (TRUE) : (FALSE))

#define AppendSArray(sarray, i1) \
(*(sarray)->curr_saitem++ = (SARRAY_ELEMENT)(i1))

#define GetSArraySize(sarray) \
((unsigned long)((sarray)->curr_saitem - (&(sarray)->saitems[0])))

#define GetSArrayItem(sarray, index) \
((sarray)->saitems[(index)])

#define GetSArray(sarray) \
(&(sarray)->saitems[0])

#define DeleteSArray(sarray) \
free(sarray)

#define ClearSArray(sarray) \
((sarray)->curr_saitem = &(sarray)->saitems[0])


SARRAY *CreateSArray(unsigned long size);
SARRAY *CopySArray(SARRAY *src);

void SortSArray(SARRAY *sarray);

#endif /* SARRAY_H */
