#ifndef PTNET_H
#define PTNET_H

#include <stdio.h>
#include "combi.h"
#include "bitarr.h"
#include "buchi.h"


typedef struct place {
  struct arc *preset;
  struct arc *postset;
  unsigned long id;
  char *name;
  char *meaning;
  unsigned long initial_marking;
} Place;


typedef struct transition {
  struct arc *preset;
  struct arc *postset;
  unsigned long id;
  char *name;
  char *meaning;
  BOOL buchi_trans;
  BOOL accepting;
} Transition;


typedef struct arc {
  struct arc *nextplace;
  struct arc *nexttransition;
  struct place *place;
  struct transition *transition;
} Arc;


typedef struct alist {
  struct alist *next;
  struct arc *arc;
} Alist;


class PTNet
{
public:

  PTNet(BOOL do_ltl);
  ~PTNet();

  BOOL ReadPEP(FILE *in);

  Place **getPlaces(void) {return places;};
  Transition **getTransitions(void) {return transitions;};

  unsigned long getNumPlaces(void) {return numplaces;};
  unsigned long getNumTransitions(void) {return numtransitions;};
  unsigned long getNumArcs(void) {return numarcs;};

  char *getPlName(unsigned long id) {return places[id -1]->name;};
  char *getTrName(unsigned long id) {return transitions[id -1]->name;};
  unsigned long getPlId(char *name);

  BOOL isInInitialState(unsigned long id) {return ((places[id -1]->initial_marking > 0) ?
						   (TRUE): (FALSE)); };
  BOOL isInAnyState(unsigned long id) {return TRUE;} // Safe approximation, TODO: implement me
  BOOL isAccepting(unsigned long id) {return (transitions[id -1]->accepting); };
  BOOL isObservablePlace(unsigned long id);
  BOOL isBuchiPlace(unsigned long id);
  BOOL isBuchiTransition(unsigned long id) {return (transitions[id -1]->buchi_trans); };
  BOOL isInvisiblePlace(unsigned long id) {return GetBit(invisible_places, (id -1)); };
  BOOL isInvisibleTransition(unsigned long id) {return GetBit(invisible_transitions, (id -1)); };
  BOOL isLTransition(unsigned long id) {return GetBit(L_transitions, (id -1)); };
  char *getObservableName(unsigned long id);

  BOOL CanStutter(unsigned long transition_idx,
		  unsigned long num_places,
		  unsigned long *places) {return (buchi->CanStutter(transition_idx,
								    num_places,
								    places)); };
  unsigned long getBuchiPrePlace(unsigned long id);
  unsigned long getBuchiPostPlace(unsigned long id);
  

protected:

  BOOL insertPlace(unsigned long numname,
		   char *name,
		   char *meaning,
		   unsigned long initial_marking);
  BOOL insertTransition(unsigned long numname,
			char *name,
			char *meaning);
  BOOL insertTPArc(unsigned long transitionname,
		   unsigned long placename);
  BOOL insertPTArc(unsigned long placename,
		   unsigned long transitionname);
  void initPTNet(void);
  void initLTL(void);


  Place **places;
  Transition **transitions;
  Alist *alist;

  unsigned long numplaces;
  unsigned long numtransitions;
  unsigned long numarcs;

  Place **placesbyname;
  Transition **transitionsbyname;

  unsigned long maxplaces;
  unsigned long maxtransitions;

  BOOL do_ltl;
  unsigned long maxplnumname;
  unsigned long maxtrnumname;

  BITARRAY *invisible_places;
  BITARRAY *invisible_transitions;
  BITARRAY *L_transitions;

  Buchi *buchi;

private:

  BOOL ReadLine(FILE *in);
  BOOL GetKeyword(const char *keyword);
  void RemoveComments(void);
  void SetCursor(char *newcursor) {cursor = newcursor;};
  BOOL isNumber(void);
  BOOL isString(void);
  int getNumber(void);
  char* getString(void);

  char *buf;
  char *cursor;

  unsigned long GetPlNumName(Place *pl);
  Transition *MakeLivelockTransitionCopy(Transition *t, unsigned long id);
  void CopyPreAndPostSets(Transition *dst, Transition *src,
			  Place *livelock_mode, unsigned long first_created_place);

};

#define BUFSIZE 4097 /* The same as in PEP */


#endif /* PTNET_H */

