#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include <string.h>
#include <strings.h>
#include <limits.h>
#include "alloc.h"
#include "dassert.h"
#include "ptnet.h"

#define MAX(a,b) (((a) >= (b)) ? (a) : (b))

PTNet::PTNet(BOOL in_do_ltl)
{
  do_ltl = in_do_ltl;

  buf = (char *)xmalloc(BUFSIZE);
  cursor = (char *)NULL;

  maxplaces = 1;
  maxtransitions = 1;

  placesbyname = (Place **)xmalloc(sizeof(Place *));
  placesbyname[0] = (Place *)NULL;
  transitionsbyname = (Transition **)xmalloc(sizeof(Transition *));
  transitionsbyname[0] = (Transition *)NULL;

  numplaces = 0;
  numtransitions = 0;
  numarcs = 0;

  places = (Place **)NULL;
  transitions = (Transition **)NULL;

  alist = (Alist *)NULL;

  maxplnumname = 0;
  maxtrnumname = 0;

  invisible_places = (BITARRAY *)NULL;
  invisible_transitions = (BITARRAY *)NULL;
  L_transitions = (BITARRAY *)NULL;

  buchi = (Buchi *)NULL;

}


PTNet::~PTNet()
{
  unsigned long i;

  Alist *al;
  Alist *tmp;

  if(buchi != NULL) {
    delete(buchi);
  }
  if(L_transitions != NULL) {
    DeleteBitArray(L_transitions);
  }
  if(invisible_transitions != NULL) {
    DeleteBitArray(invisible_transitions);
  }
  if(invisible_places != NULL) {
    DeleteBitArray(invisible_places);
  }

  free(buf);
  free(placesbyname);
  free(transitionsbyname); 

  for(tmp = alist; tmp != NULL;) {

    al = tmp;
    tmp = tmp->next;

    free(al->arc);
    free(al);

    numarcs--;

  }

  ASSERT(numarcs == 0);

  for(i = 0; i < numplaces; i++) {
    if(places[i]->name != NULL) {
      free(places[i]->name);
    }
    if(places[i]->meaning != NULL) {
      free(places[i]->meaning);
    }
    free(places[i]);
  }

  free(places);

  
  for(i = 0; i < numtransitions; i++) {
    if(transitions[i]->name != NULL) {
      free(transitions[i]->name);
    }
    if(transitions[i]->meaning != NULL) {
      free(transitions[i]->meaning);
    }
    free(transitions[i]);
  }

  free(transitions);
  
}



BOOL PTNet::ReadPEP(FILE *in)

{
  BOOL OK = TRUE;
  BOOL autonumber = TRUE;
  BOOL numspecified;
  BOOL gotcoords;
  BOOL PetriBox = FALSE;
  unsigned long mode = 0;
  unsigned long line = 0;
  int autocount = 0;
  int num;
  int x;
  int y;
  char *str;

  char *meaning;
  int marking;
  BOOL entry;
  BOOL exit;

  int tmp;
  char *tmpstr;

  while((mode != 8) &&
	OK &&
	ReadLine(in) != FALSE) {

    line++;

    if(mode >= 3) {
      RemoveComments();
    }

    if(strlen(buf) == 0) {
      continue;
    }
#if 0
    fprintf(stdout, "Mode: %lu, \"%s\"\n", mode, buf);
#endif
    SetCursor(buf); // Init the cursor to the beginning of line


    switch(mode) {

    case 0:
      if(GetKeyword("PEP")) {
	mode = 1;
      } else {
	OK = FALSE;
      }
      break;

    case 1:
      if(GetKeyword("PetriBox")) {
	PetriBox = TRUE;
      }
      if(GetKeyword("PetriBox") || GetKeyword("PTNet")) {
	mode = 2;
      } else {
	OK = FALSE;
      }
      break;

    case 2:
      if(GetKeyword("FORMAT_N")) {
	mode = 3;
      } else {
	OK = FALSE;
      }
      break;

    case 3:

      // I really should handle the other keywords here, but I'm too
      // lazy to implement them now, so this will do for now. 20/09/2000/kepa

      if(GetKeyword("PL")) {
	mode = 4;

	autonumber = TRUE;
	autocount = 0;

      }

      // Didn't find the places yet, keep scanning forward

      break;

    case 4:

      if(GetKeyword("TR")) {
	mode = 5;


	autonumber = TRUE;
	autocount = 0;

      } else {

	// The place handling comes here

	if(autonumber) {
	  autocount++;
	}

	numspecified = FALSE; // Is the place number specified
	gotcoords = FALSE; // Are the coordinates specified

	num = 0;
	str = (char *)NULL;
	x = 0;
	y = 0;

	meaning = (char *)NULL;
	marking = 0;
	entry = FALSE;
	exit = FALSE;


	if(!(isNumber() || isString())) {
	  OK = FALSE;
	  break;
	}


	if(isNumber()) {

	  x = getNumber(); // Place number or x-coordinate

	  if(cursor[0] == '@') {

	    // OK, we have only coordinates here

	    cursor++;

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    y = getNumber();
	    gotcoords = TRUE;


	  } else {

	    if(x < 0) {
	      OK = FALSE;
	      break;
	    }

	    num = x;
	    x = 0;
	    numspecified = TRUE;
	    autonumber = FALSE;

	  }

	}


	if(isString()) {

	  if(gotcoords) {
	    OK = FALSE;
	    break;
	  }

	  str = getString();

	}


	if((!gotcoords) && isNumber()) {

	  x = getNumber(); // Place number or x-coordinate

	  if(cursor[0] != '@') {
	    OK = FALSE;
	    break;
	  }

	  // OK, we have only coordinates here

	  cursor++;

	  if(!isNumber()) {
	    OK = FALSE;
	    break;
	  }

	  y = getNumber();
	  gotcoords = TRUE;

	}


	// Unlike the documentation states, the coordinates don't
	// seem to be necessary!

#if NO_GOT_COORDS_BAD
	if(!gotcoords) {
	  OK = FALSE;
	  break;
	}
#endif

	if(!numspecified) {

	  if(autonumber) {
	    num = autocount;
	    numspecified = TRUE;
	  } else {
	    OK = FALSE;
	    break;
	  }

	}


	while(OK &&
	      cursor[0] != '\0') {

	  // Process the optional place stuff

	  switch(cursor[0]) {

	  case 'b':
	    cursor++;

	    // Meaning string

	    if(!isString()) {
	      OK = FALSE;
	      break;
	    }

	    meaning = getString();

	    break;

	  case 'M':
	    cursor++;

	    // Initial marking

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    marking = getNumber();

	    if(marking < 0) {
	      OK = FALSE;
	      break;
	    }

	    break;

	  case 'e':
	    cursor++;

	    entry = TRUE;

	    break;

	  case 'x':
	    cursor++;

	    exit = TRUE;

	    break;

	  case 'n':
	  case 'a':
	  case 'N':
	  case 'A':
	    cursor++;

	    // Coordinates ignored

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    if(cursor[0] != '@') {
	      OK=FALSE;
	      break;
	    }

	    cursor++;

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    break;

	  case 'm':
	  case 'k':
	  case 'v':
	  case 's':
	  case 't':
	  case 'c':
	    cursor++;

	    // Current marking, capasity, invisible,
	    // sx, thickness, and color ignored

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    break;


	  case 'R':
	  case 'T':
	  case 'u':
	    cursor++;

	    // Reference string, TReference string,
	    // and blocks list ignored

	    if(!isString()) {
	      OK = FALSE;
	      break;
	    }

	    tmpstr = getString();
	    free(tmpstr);

	    break;

	  default:
	    cursor++;

	    if(isspace(cursor[-1])) {
	      break;
	    }

	    OK = FALSE;
	    break;

	  }

	}


	// Entry and exit places should only exist in Petriboxes
	// but never both at the same time

	if(((!PetriBox) && entry) ||
	   ((!PetriBox) && exit) ||
	   (entry && exit)) {
	  OK = FALSE;
	}

	// Drop out of thew outer loop also if not OK

	if(OK == FALSE) {
	  break;

	}

	
	if(entry) {
	  marking = 1; // Entry place have the initial marking 1
	}


	// Everything set, print the stuff

#if 0
	fprintf(stdout, "Place number %d, at coordinates %d@%d, initial marking %d",
		num, x, y, marking);
	if(str != NULL) {
	  fprintf(stdout, ", name:\"%s\"", str);
	}
	if(meaning != NULL) {
	  fprintf(stdout, ", meaning:\"%s\"", meaning);
	}
	fprintf(stdout, "\n");
#endif

	if(insertPlace(num, str, meaning, marking) == FALSE) {
	  fprintf(stderr, "Place number %d multiply defined!\n", num);
	  OK = FALSE;
	  break;
	}

      }

      break;

    case 5:

      if(GetKeyword("TP")) {
	mode = 6;
      } else {

	// The transition handling comes here

	if(autonumber) {
	  autocount++;
	}

	numspecified = FALSE; // Is the transition number specified
	gotcoords = FALSE; // Are the coordinates specified

	num = 0;
	str = (char *)NULL;
	x = 0;
	y = 0;

	meaning = (char *)NULL;
	marking = 0;
	entry = FALSE;
	exit = FALSE;


	if(!(isNumber() || isString())) {
	  OK = FALSE;
	  break;
	}


	if(isNumber()) {

	  x = getNumber(); // Transition number or x-coordinate

	  if(cursor[0] == '@') {

	    // OK, we have only coordinates here

	    cursor++;

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    y = getNumber();
	    gotcoords = TRUE;


	  } else {

	    if(x < 0) {
	      OK = FALSE;
	      break;
	    }

	    num = x;
	    x = 0;
	    numspecified = TRUE;
	    autonumber = FALSE;

	  }

	}


	if(isString()) {

	  if(gotcoords) {
	    OK = FALSE;
	    break;
	  }

	  str = getString();

	}


	if((!gotcoords) && isNumber()) {

	  x = getNumber(); // Transition number or x-coordinate

	  if(cursor[0] != '@') {
	    OK = FALSE;
	    break;
	  }

	  // OK, we have only coordinates here

	  cursor++;

	  if(!isNumber()) {
	    OK = FALSE;
	    break;
	  }

	  y = getNumber();
	  gotcoords = TRUE;

	}


	// Unlike the documentation states, the coordinates don't
	// seem to be necessary!

#if NO_GOT_COORDS_BAD
	if(!gotcoords) {
	  OK = FALSE;
	  break;
	}
#endif

	if(!numspecified) {

	  if(autonumber) {
	    num = autocount;
	    numspecified = TRUE;
	  } else {
	    OK = FALSE;
	    break;
	  }

	}


	while(OK &&
	      cursor[0] != '\0') {

	  // Process the optional transition stuff

	  
	  switch(cursor[0]) {

	  case 'b':
	    cursor++;

	    // Meaning string

	    if(!isString()) {
	      OK = FALSE;
	      break;
	    }

	    meaning = getString();

	    break;

	  case 'n':
	  case 'a':
	  case 'N':
	  case 'A':
	    cursor++;

	    // Coordinates ignored

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    if(cursor[0] != '@') {
	      OK=FALSE;
	      break;
	    }

	    cursor++;

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    break;

	  case 'v':
	  case 's':
	  case 't':
	  case 'c':
	    cursor++;

	    // Invisible, sx, thickness, and color ignored

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    break;


	  case 'R':
	  case 'T':
	  case 'u':
	    cursor++;

	    // Reference string, TReference string,
	    // and blocks list ignored

	    if(!isString()) {
	      OK = FALSE;
	      break;
	    }

	    tmpstr = getString();
	    free(tmpstr);

	    break;

	  case 'P':
	  case 'S':
	    cursor++;

	    // Synchronization ignored and phantom transitions
	    // not correctly handled, so give an error isntead of
	    // silently ignoring them

	    OK = FALSE;
	    break;

	  default:
	    cursor++;

	    if(isspace(cursor[-1])) {
	      break;
	    }

	    OK = FALSE;
	    break;

	  }

	}


	// Drop out of thew outer loop also if not OK

	if(OK == FALSE) {
	  break;

	}

	
	// Everything set, print the stuff

#if 0
	fprintf(stdout, "Transition number %d, at coordinates %d@%d",
		num, x, y);
	if(str != NULL) {
	  fprintf(stdout, ", name:\"%s\"", str);
	}
	if(meaning != NULL) {
	  fprintf(stdout, ", meaning:\"%s\"", meaning);
	}
	fprintf(stdout, "\n");
#endif

	if(insertTransition(num, str, meaning) == FALSE) {
	  fprintf(stderr, "Transition number %d multiply defined!\n", num);
	  OK = FALSE;
	  break;
	}

      }

      break;

    case 6:

      if(GetKeyword("PT")) {
	mode = 7;
      } else {

	// The transition -> place arc handling comes here

	if(isNumber()) {

	  x = getNumber();

	  if(cursor[0] != '<') {
	    OK = FALSE;
	    break;
	  }

	  cursor++;

	  if(isNumber()) {
	  
	    y = getNumber();
	  
	    if((x < 0) ||
	       (y < 0)) {
	      OK = FALSE;
	      break;
	    }

	    // TODO: Check that the rest of the line is OK!
#if 0
	    fprintf(stdout, "Arc from transition %d to place %d\n",
		    x, y);
#endif
	    if(insertTPArc(x, y) == FALSE) {
	      fprintf(stderr, "Arc from transition %d to place %d could not be added!\n",
		      x, y);
	      OK = FALSE;
	      break;
	    }

	  } else {
	    OK = FALSE;
	    break;
	  }


	} else {
	  OK = FALSE;
	  break;
	}
	
      }

      break;

    case 7:

      if(GetKeyword("PTP") || GetKeyword("PPT") || GetKeyword("TX")) {
	mode = 8;
      } else {

	// The place -> transition arc handling comes here

	if(isNumber()) {

	  x = getNumber();

	  if(cursor[0] != '>') {
	    OK = FALSE;
	    break;
	  }

	  cursor++;

	  if(isNumber()) {
	  
	    y = getNumber();
	  
	    if((x < 0) ||
	       (y < 0)) {
	      OK = FALSE;
	      break;
	    }


	    // TODO: Check that the rest of the line is OK!
#if 0
	    fprintf(stdout, "Arc from place %d to transition %d\n",
		    x, y);
#endif
	    if(insertPTArc(x, y) == FALSE) {
	      fprintf(stderr, "Arc from place %d to transition %d could not be added!\n",
		      x, y);
	      OK = FALSE;
	      break;
	    }


	  } else {
	    OK = FALSE;
	    break;
	  }


	} else {
	  OK = FALSE;
	  break;
	}
	
      }

      break;

    }


  }


  if((mode < 7) ||
     (OK == FALSE) ||
     (ferror(in))) {

    fprintf(stderr, "Error encountered on line %lu\n", line);
    return FALSE;

  }

  initPTNet();

  return TRUE;

}



BOOL PTNet::ReadLine(FILE *in)

{
  size_t len;

  if(fgets(buf, BUFSIZE, in) == NULL) {
    return FALSE;
  }

  if(ferror(in)) {
    return FALSE;
  }

  len = strlen(buf);

  if(len > 0) {

    if(buf[len-1] == '\n') {

      buf[len-1] = '\0';

    }

  }

  return TRUE;

}


BOOL PTNet::GetKeyword(const char *keyword)

{
  size_t len = strlen(keyword);

  if(!strncmp(buf, keyword, len)) {
    return TRUE;
  }

  return FALSE;


}


void PTNet::RemoveComments(void)

{
  unsigned long i;
  unsigned long size;
  BOOL instring;
  char *p;

  size = strlen(buf);

  p = NULL;
  instring = FALSE;
  for(i = 0; i < size; i++) {

    if(buf[i] == '"') {

      if(instring == FALSE) {
	instring = TRUE;
      } else {
	instring = FALSE;
      }

      continue;

    }
     
    if(instring == FALSE) {
      if(buf[i] == '\%') {

	p = &buf[i];
	break;

      }

    }

  }

  if(p != NULL) {

    *p = '\0';

  }

  return;

}


BOOL
PTNet::isNumber(void)

{
  int tmp = 0;

  ASSERT(cursor != NULL);

  if(sscanf(cursor, "%d", &tmp) == 1) { 

    return TRUE;

  }

  return FALSE;

}

int
PTNet::getNumber(void)

{
  int tmp = 0;

  ASSERT(cursor != NULL);

  if(sscanf(cursor, "%d", &tmp) == 1) { 

    while(isspace(*cursor)) {
      cursor++;
    }

    if(cursor[0] == '-'){
      cursor++;
    }

    while(isdigit(*cursor)) {
      cursor++;
    }

    return tmp;

  }

  ASSERT(FALSE);

  return 0;

}


BOOL
PTNet::isString(void)

{

  ASSERT(cursor != NULL);


  if((cursor[0] == '\"') &&
     (strchr(&cursor[1], '\"') != NULL)) {

    return TRUE;

  }

  return FALSE;

}


char *
PTNet::getString(void)

{
  char *tmp;
  char *tmp2;

  ASSERT(cursor != NULL);
  ASSERT(cursor[0] == '\"');

  tmp = strchr(&cursor[1], '\"');

  ASSERT(tmp != NULL);

  *tmp = '\0';

  tmp2 = strdup(&cursor[1]);

  *tmp = '\"';

  ASSERT(tmp2 != NULL);

  cursor = &tmp[1];
  
  return tmp2;

}



BOOL PTNet::insertPlace(unsigned long numname,
			char *name,
			char *meaning,
			unsigned long initial_marking)
{
  unsigned long newplaces;
  unsigned long i;
  Place *pl;

  if(numname >= maxplaces) {

    for(newplaces = maxplaces; numname >= newplaces; newplaces += newplaces) {
      ;
    }

    placesbyname = (Place **)xrealloc(placesbyname, (newplaces * sizeof(Place *)));

    for(i = maxplaces; i < newplaces; i++) {
      placesbyname[i] = (Place *)NULL;
    }

    maxplaces = newplaces;
    
  }

  if(placesbyname[numname] != NULL) {

    return FALSE;

  }

  pl = (Place *)xmalloc(sizeof(Place));

  pl->preset = NULL;       // These fields initialized later
  pl->postset = NULL;
  pl->id = 0;

  pl->name = name;
  pl->meaning = meaning;
  pl->initial_marking = initial_marking;

  placesbyname[numname] = pl;

  maxplnumname = MAX(maxplnumname, numname);

  return TRUE;

}



BOOL PTNet::insertTransition(unsigned long numname,
			     char *name,
			     char *meaning)

{

  unsigned long newtransitions;
  unsigned long i;
  Transition *tr;

  if(numname >= maxtransitions) {

    for(newtransitions = maxtransitions; numname >= newtransitions; newtransitions += newtransitions) {
      ;
    }

    transitionsbyname = (Transition **)xrealloc(transitionsbyname,
						(newtransitions * sizeof(Transition *)));

    for(i = maxtransitions; i < newtransitions; i++) {
      transitionsbyname[i] = (Transition *)NULL;
    }

    maxtransitions = newtransitions;
    
  }

  if(transitionsbyname[numname] != NULL) {

    return FALSE;

  }

  tr = (Transition *)xmalloc(sizeof(Transition));

  tr->preset = NULL;       // These fields initialized later
  tr->postset = NULL;
  tr->id = 0;

  tr->name = name;
  tr->meaning = meaning;
  tr->buchi_trans = FALSE; // This is initialized later if needed
  tr->accepting = FALSE; // This is initialized later if needed

  transitionsbyname[numname] = tr;

  maxtrnumname = MAX(maxtrnumname, numname);

  return TRUE;

}



BOOL PTNet::insertTPArc(unsigned long transitionname,
			unsigned long placename)
{
  Arc *ac;
  Alist *al; // For easy deallocation

  if((transitionsbyname[transitionname] == NULL) ||
     (placesbyname[placename] == NULL)) {

    return FALSE; // Either end of the arc doesn't exist

  }

  ac = (Arc *)xmalloc(sizeof(Arc));

  ac->place = placesbyname[placename];
  ac->transition = transitionsbyname[transitionname];

  // Transition postset extension

  ac->nextplace = ac->transition->postset;
  ac->transition->postset = ac;

  // Place preset extension

  ac->nexttransition = ac->place->preset;
  ac->place->preset = ac;


  al = (Alist *)xmalloc(sizeof(Alist));

  al->arc = ac;
  al->next = alist;
  alist = al;

  numarcs++;

  return TRUE;

}


BOOL PTNet::insertPTArc(unsigned long placename,
			unsigned long transitionname)

{

  Arc *ac;
  Alist *al; // For easy deallocation

  if((transitionsbyname[transitionname] == NULL) ||
     (placesbyname[placename] == NULL)) {

    return FALSE; // Either end of the arc doesn't exist

  }

  ac = (Arc *)xmalloc(sizeof(Arc));

  ac->place = placesbyname[placename];
  ac->transition = transitionsbyname[transitionname];

  // Transition preset extension

  ac->nextplace = ac->transition->preset;
  ac->transition->preset = ac;

  // Place postset extension

  ac->nexttransition = ac->place->postset;
  ac->place->postset = ac;


  al = (Alist *)xmalloc(sizeof(Alist));

  al->arc = ac;
  al->next = alist;
  alist = al;

  numarcs++;

  return TRUE;

}


void PTNet::initPTNet(void)
{
  unsigned long i;

  for(i = 0; i < maxplaces; i++) {

    if(placesbyname[i] != NULL) {
      numplaces++;
    }

  }

  places = (Place **)xmalloc(numplaces * sizeof(Place *));
  numplaces = 0;

  for(i = 0; i < maxplaces; i++) {

    if(placesbyname[i] != NULL) {

      places[numplaces] = placesbyname[i];
      numplaces++;
      places[numplaces -1]->id = numplaces;
    }

  }


  for(i = 0; i < maxtransitions; i++) {

    if(transitionsbyname[i] != NULL) {
      numtransitions++;
    }

  }

  transitions = (Transition **)xmalloc(numtransitions * sizeof(Transition *));
  numtransitions = 0;

  for(i = 0; i < maxtransitions; i++) {

    if(transitionsbyname[i] != NULL) {

      transitions[numtransitions] = transitionsbyname[i];
      numtransitions++;
      transitions[numtransitions -1]->id = numtransitions;
    }

  }

#if 0
  fprintf(stdout, "Places: %lu, transitions: %lu\n",
	  numplaces, numtransitions);
#endif

  if(do_ltl != FALSE) {
    initLTL();
#if 0
    fprintf(stdout, "LTL Places: %lu, transitions: %lu\n",
	    numplaces, numtransitions);
#endif
  }

}


void PTNet::initLTL(void)
{
  unsigned long i;
  unsigned long j;
  unsigned long accept_all_index;
  unsigned long step_formula_index;
  unsigned long step_system_index;
  unsigned long num_created_trans;
  unsigned long num_created_places;
  unsigned long first_created_trans;
  unsigned long first_created_place;
  BOOL first;
  BOOL found;
  char *name;
  Transition **tr;
  Transition *t;
  Arc *ac;
#if 0
  Arc *ac2;
#endif

  // Check if there is an accept-all place

  accept_all_index = ULONG_MAX;
  for(i = 0; i < numplaces; i++) {
    if(places[i]->name != NULL) {
      if(strncmp(places[i]->name, "_c_P", 4) == 0) {

	// This is a created place
    
	if(places[i]->meaning != NULL) {
	  if(strcmp(places[i]->meaning, "#_buechi_accept_all") == 0) {

	    // This created place has a special semantic meaning
	    // Whenever a token arrives on it, all infinite sequences
	    // of transitions after its' occurrence are accepting

	    accept_all_index = i;
	    break;

	  }
	}
      }
    }
  }


  // Find the step-formula place

  step_formula_index = ULONG_MAX;
  for(i = 0; i < numplaces; i++) {
    if(places[i]->name != NULL) {
      if(strncmp(places[i]->name, "_c_P", 4) == 0) {

	// This is a created place
    
	if(places[i]->meaning != NULL) {
	  if(strcmp(places[i]->meaning, "step_formula") == 0) {

	    step_formula_index = i;
	    break;

	  }
	}
      }
    }
  }
  ASSERT(step_formula_index != ULONG_MAX);


  // Find the step-system place

  step_system_index = ULONG_MAX;
  for(i = 0; i < numplaces; i++) {
    if(places[i]->name != NULL) {
      if(strncmp(places[i]->name, "_c_P", 4) == 0) {

	// This is a created place
    
	if(places[i]->meaning != NULL) {
	  if(strcmp(places[i]->meaning, "step_system") == 0) {

	    step_system_index = i;
	    break;

	  }
	}
      }
    }
  }
  ASSERT(step_system_index != ULONG_MAX);





  // Get the number of created transitions, and the offset of the first one
  //
  // Also check that they are at the end of the transitions list

  num_created_trans = 0;
  first = TRUE;
  first_created_trans = ULONG_MAX;
  for(i = 0; i < numtransitions; i++) {
    name = transitions[i]->name;
    if(name != NULL) {
      if(*name == '@') {
	name ++;
	if(strncmp(name, "_c_T", 4) == 0) {
	  // This is an accepting transition, mark it
	  transitions[i]->accepting = TRUE;
	}
      }
      if(strncmp(name, "_c_T", 4) == 0) {
	if(first != FALSE) {
	  first_created_trans = i;
	  first = FALSE;
	}
	transitions[i]->buchi_trans = TRUE;
	num_created_trans++;
      } else {
	// Created transitions should be the last ones in the transitions list
	ASSERT(first != FALSE);
      }

    } else {
      // Created transitions should be the last ones in the transitions list
      ASSERT(first != FALSE);
    }

  }
  ASSERT(first_created_trans != ULONG_MAX);



  // Get the number of created places, and the offset of the first one
  //
  // Also check that they are at the end of the places list

  num_created_places = 0;
  first = TRUE;
  first_created_place = ULONG_MAX;
  for(i = 0; i < numplaces; i++) {
    name = places[i]->name;
    if(name != NULL) {
      if(strncmp(name, "_c_P", 4) == 0) {
	if(first != FALSE) {
	  first_created_place = i;
	  first = FALSE;
	}
	num_created_places++;
      } else {
	// Created places should be the last ones in the places list
	ASSERT(first != FALSE);
      }

    } else {
      // Created places should be the last ones in the places list
      ASSERT(first != FALSE);
    }

  }
  ASSERT(first_created_place != ULONG_MAX);


  // Get the numeric names of the indexes

  step_formula_index = GetPlNumName(places[step_formula_index]);
  step_system_index = GetPlNumName(places[step_system_index]);


  // Check if we have an accept-all place, and handle it in a special way

  if(accept_all_index != ULONG_MAX) {

    // An accept-all place found, check if it has a preset

    if(places[accept_all_index]->preset != NULL) {

      // The accept-all place could have a token
      // We'll emulate the special semantics of the accept-all place
      // by adding an accepting transition into its' postset

      numtransitions++;
      num_created_trans++;
      sprintf(buf, "@_c_T%lu", num_created_trans);
      insertTransition((maxtrnumname +1), strdup(buf), strdup("^[tt]"));
      transitions = (Transition **)xrealloc(transitions,
					    (numtransitions * sizeof(Transition *)));
      transitions[numtransitions -1] = transitionsbyname[maxtrnumname];
      transitions[numtransitions -1]->id = numtransitions;
      transitions[numtransitions -1]->buchi_trans = TRUE;
      transitions[numtransitions -1]->accepting = TRUE;

      accept_all_index = GetPlNumName(places[accept_all_index]);

      // Add an arc from accept-all to the preset

      insertPTArc(accept_all_index, maxtrnumname);

      // Add an arc from step_formula to the preset

      insertPTArc(step_formula_index, maxtrnumname);

      // Add an arc to accept-all to the post

      insertTPArc(maxtrnumname, accept_all_index);

      // Add an arc to step_system to the postset

      insertTPArc(maxtrnumname, step_system_index);

      // The transition has been created, update the transitions index

    }

  }


  // Create a new place for livelock transition postsets

  numplaces++;
  num_created_places++;
  sprintf(buf, "_c_P%lu", num_created_places);
  insertPlace((maxplnumname +1), strdup(buf), strdup("livelock_mode"), 0);
  places = (Place **)xrealloc(places,
			      (numplaces * sizeof(Place *)));
  places[numplaces -1] = placesbyname[maxplnumname];
  places[numplaces -1]->id = numplaces;


  // We'll create copies of all created transitions next, allocate memory
  // for them

  tr = (Transition **)xmalloc((numtransitions + num_created_trans) *
			      sizeof(Transition *));

  // Copy the normal transitions to the new array
  for(i = 0; i < (numtransitions - num_created_trans); i++) {
    tr[i] = transitions[i];
  }


  L_transitions = CreateBitArray(numtransitions + num_created_trans);

  // Copy the created transitions twice
  // First as a normal one, and secondly as a "livelock"-copy
  // Note: We do not re-initialize "i" here!
  ASSERT(i = first_created_trans);

  for(j = 0; i < numtransitions; i++, j++) {

    t = transitions[i];

    tr[i + j] = t;
    t->id = (i + j + 1);
    t = MakeLivelockTransitionCopy(t, (i + j + 2));
    tr[i + j + 1] = t;

  }

  free(transitions);
  transitions = tr;
  numtransitions += num_created_trans;


  // The copy pre & postsets for the livelock transitions

  for(i = first_created_trans, j = 0; j < num_created_trans; i++, j ++) {
    CopyPreAndPostSets(tr[i+j+1],
		       tr[i+j],
		       places[numplaces -1],
		       first_created_place);
  }

  num_created_trans *= 2;


  // Remember which places and transitions are invisible

  invisible_places = CreateBitArray(numplaces);
  invisible_transitions = CreateBitArray(numtransitions);

  // Only non-created transitions can be invisible
  for(i = 0; i < (numtransitions - num_created_trans); i++) {

    found = FALSE;
    for(ac = transitions[i]->preset;
	ac != NULL;
	ac = ac->nextplace) {

      name = ac->place->name;
      if((name != NULL) &&
	 (strncmp(name, "_c_P", 4) == 0)) {

	// Found a created place in the preset, this is a
	// visible transition

	// Check that the ID really agrees

	ASSERT(ac->place->id > first_created_place);

	found = TRUE;
	break;

      }

    }

    if(found == FALSE) {

      for(ac = transitions[i]->postset;
	  ac != NULL;
	  ac = ac->nextplace) {

	name = ac->place->name;
	if((name != NULL) &&
	   (strncmp(name, "_c_P", 4) == 0)) {

	  // Found a created place in the postset, this is a
	  // visible transition

	  // Check that the ID really agrees

	  ASSERT(ac->place->id > first_created_place);

	  found = TRUE;
	  break;

	}

      }


    }

  

    if(found == FALSE) {

      // This is an invisible transition

      SetBit(invisible_transitions, i);

    }

  }


  for(i = 0; i < numtransitions; i++) {

    // Invisible places are those which appear as presets to invisible transitions

    if(isInvisibleTransition(i+1) != FALSE) {

      for(ac = transitions[i]->preset;
	  ac != NULL;
	  ac = ac->nextplace) {

	SetBit(invisible_places, (ac->place->id -1));
	
      }

    }

  }
  
  buchi = new Buchi(this);

  // Check that the place invisibility is setup OK!

  for(i = 0; i < numtransitions; i++) {

    if(isInvisibleTransition(i+1) != FALSE) {

      for(ac = transitions[i]->preset;
	  ac != NULL;
	  ac = ac->nextplace) {

	if(isInvisiblePlace(ac->place->id) == FALSE) {

	  // Invariant violated: Invisible transition has a visible place in preset!
	  
	  ASSERT(FALSE);
	  
	}

      }

    }

  }

  
}


void
PTNet::CopyPreAndPostSets(Transition *dst, Transition *src,
			  Place *livelock_mode, unsigned long first_created_place)
{
  Arc *ac;
  Arc *ac2;
  Alist *al;

  // Places will be in reverse order in the copy, but that's all right

  for(ac = src->preset;
      ac != NULL;
      ac = ac->nextplace) {

    ac2 = (Arc *)xmalloc(sizeof(Arc));

    ac2->place = ac->place;
    ac2->transition = dst;

    // Transition preset extension
    
    ac2->nextplace = ac2->transition->preset;
    ac2->transition->preset = ac2;

    // Place postset extension

    ac2->nexttransition = ac2->place->postset;
    ac2->place->postset = ac2;


    al = (Alist *)xmalloc(sizeof(Alist));

    al->arc = ac2;
    al->next = alist;
    alist = al;

    numarcs++;

  }


  // Places will be in reverse order in the copy, but that's all right

  for(ac = src->postset;
      ac != NULL;
      ac = ac->nextplace) {

    // Do not add any created places in the postset

    if(ac->place->id >= (first_created_place +1)) {
      continue;
    }

    ac2 = (Arc *)xmalloc(sizeof(Arc));

    ac2->place = ac->place;
    ac2->transition = dst;

    // Transition postset extension

    ac2->nextplace = ac2->transition->postset;
    ac2->transition->postset = ac2;

    // Place preset extension

    ac2->nexttransition = ac2->place->preset;
    ac2->place->preset = ac2;


    al = (Alist *)xmalloc(sizeof(Alist));

    al->arc = ac2;
    al->next = alist;
    alist = al;

    numarcs++;

  }


  // Add the livelock mode place to the postset

  ac2 = (Arc *)xmalloc(sizeof(Arc));

  ac2->place = livelock_mode;
  ac2->transition = dst;

  // Transition postset extension

  ac2->nextplace = ac2->transition->postset;
  ac2->transition->postset = ac2;

  // Place preset extension

  ac2->nexttransition = ac2->place->preset;
  ac2->place->preset = ac2;


  al = (Alist *)xmalloc(sizeof(Alist));

  al->arc = ac2;
  al->next = alist;
  alist = al;

  numarcs++;

}


Transition *
PTNet::MakeLivelockTransitionCopy(Transition *t, unsigned long id)
{
  Transition *tr;

  tr = (Transition *)xmalloc(sizeof(Transition));

  tr->preset = NULL;       // These fields initialized later
  tr->postset = NULL;      // These fields initialized later
  tr->id = id;

  strcpy(buf, t->name);
  strcat(buf, "L");
  tr->name = strdup(buf);
  tr->meaning = strdup(t->meaning);
  tr->buchi_trans = TRUE; // These are always buchi transitions
  tr->accepting = FALSE;  // These are never accepting, even if t is!

  SetBit(L_transitions, (id -1)); // This might be an L-transition

  return (tr);

}

unsigned long
PTNet::GetPlNumName(Place *pl)
{
  unsigned long i;
  BOOL found;

  found = FALSE;
  for(i = 0; i < maxplaces; i++) {
    if(placesbyname[i] != NULL) {
      if(placesbyname[i] == pl) {
	found = TRUE;
	break;
      }
    }
  }

  ASSERT(found != FALSE);

  return (i);

}



unsigned long
PTNet::getPlId(char *name)
{
  unsigned long i;

  for(i=0; i < numplaces; i++) {

    if(!strcmp(name, places[i]->name)) {
      return (places[i]->id);
    }

  }

  return 0;

}

BOOL
PTNet::isBuchiPlace(unsigned long id)
{
  unsigned long i;
  BOOL isBuchi;

  i = id - 1;
  isBuchi = FALSE;

  if(places[i]->name != NULL) {
    if(strncmp(places[i]->name, "_c_P", 4) == 0) {

      // This is a created place
    
      if(places[i]->meaning != NULL) {

	if(strncmp(places[i]->meaning, "#_buechi_", 9) == 0) {

	  // This is a buchi place

	  isBuchi = TRUE;

	}

      }

    }

  }

  return(isBuchi);

}


BOOL
PTNet::isObservablePlace(unsigned long id)
{
  unsigned long i;
  BOOL found;
  char *meaning;

  i = id - 1;

  meaning = places[i]->meaning;
  found = FALSE;

  // Visible observed places have their meaning ending in ')'
  // and "__OBS(" appearing in them

  if((meaning != NULL) &&
     (strlen(meaning) > 7) &&
     (meaning[strlen(meaning) -1] == ')')) {

    while(*meaning != '\0') {

      if(strncmp(meaning, "__OBS(", 6) == 0) {
	found = TRUE;
	break;
      }

      meaning++;

    }

  }

  return (found);

}


char *
PTNet::getObservableName(unsigned long id)
{
  unsigned long i;
  BOOL found;
  char *meaning;
  char *name;

  i = id - 1;

  meaning = places[i]->meaning;
  found = FALSE;
  name = (char *)NULL;

  // Visible observed places have their meaning ending in ')'
  // and "__OBS(" appearing in them

  if((meaning != NULL) &&
     (strlen(meaning) > 7) &&
     (meaning[strlen(meaning) -1] == ')')) {

    while(*meaning != '\0') {

      if(strncmp(meaning, "__OBS(", 6) == 0) {
	found = TRUE;

	name = strdup(&meaning[6]);
	name[strlen(name) -1] = '\0';
	break;
      }

      meaning++;

    }

  }

  ASSERT(found == TRUE);

  return name;

}

unsigned long
PTNet::getBuchiPrePlace(unsigned long id)
{
  unsigned long i;
  Arc *ac;

  i = id -1;
  for(ac = transitions[i]->preset;
      ac != NULL;
      ac = ac->nextplace) {

    if(isBuchiPlace(ac->place->id)) {
      return(ac->place->id);
    }
    
  }
    
  // NOTREACHED

  ASSERT(FALSE);
  return(ULONG_MAX);

}

unsigned long
PTNet::getBuchiPostPlace(unsigned long id)
{
  unsigned long i;
  Arc *ac;

  i = id -1;
  for(ac = transitions[i]->postset;
      ac != NULL;
      ac = ac->nextplace) {

    if(isBuchiPlace(ac->place->id)) {
      return(ac->place->id);
    }
    
  }

  // NOTREACHED
  
  ASSERT(FALSE);
  return(ULONG_MAX);

}

#undef MAX
