#ifdef DEBUG_MONSET
#include <stdio.h>
#endif DEBUG_MONSET

#include "monset.h"
#include "alloc.h"
#include "dassert.h"
#include "ulhsort.h"

MONSET *CreateMonSet(unsigned long domainsize)
{
  MONSET *monset;
#if 0
  ASSERT(domainsize != 0);
#endif
  monset = (MONSET *)xmalloc(sizeof(MONSET) +
			     ((domainsize -1) * sizeof(MONSET_ITEM)));
  monset->monsetbits = CreateBitArray(domainsize);
  monset->curr_monsitem = &monset->monsitems[0];

  return (monset);

}

void ClearMonSet(MONSET *monset)
{
  MONSET_ITEM *curr_monsitem;
  MONSET_ITEM *monsitems;
  MONSET_ITEM item;
  BITARRAY *monsetbits;

  monsetbits = monset->monsetbits;
  curr_monsitem = monset->curr_monsitem;
  monsitems = &monset->monsitems[0];
  monset->curr_monsitem = monsitems;

  while(curr_monsitem != monsitems) {

    curr_monsitem--;
    item = *curr_monsitem;

    ClearBit(monsetbits, item);

  }

}

void DeleteMonSet(MONSET *monset)
{

  DeleteBitArray(monset->monsetbits);
  free(monset);

}


MONSET *CopyMonSet(MONSET *src)
{
  MONSET *monset;
  unsigned long i;
  unsigned long domainsize;
  unsigned long size;
  unsigned long *s;
  unsigned long *t;

  domainsize = GetBitArraySize(src->monsetbits);
  ASSERT(domainsize != 0);

  monset = (MONSET *)xmalloc(sizeof(MONSET) +
			     ((domainsize -1) * sizeof(MONSET_ITEM)));
  monset->monsetbits = CreateBitArray(domainsize);
  size = GetMonSetSize(src);
  monset->curr_monsitem = &monset->monsitems[size];

  // First copy the bits

  BitArrayCopy(src->monsetbits, monset->monsetbits);

  // Then copy the items

  s = &src->monsitems[0];
  t = &monset->monsitems[0];
  for(i = 0; i < size; i++) {
    *t++ = *s++;
  }

  return (monset);

}


void SortMonSet(MONSET *monset)
{
  unsigned long size;

  size = GetMonSetSize(monset);
  if(size > 1) {
    ULHeapSort(&monset->monsitems[0], size);
  }

}



#ifdef DEBUG_MONSET

void PrintMonSet(MONSET *monset)
{
  unsigned long i;
  unsigned long size;
  fprintf(stdout, "< ");
  for(i = 0, size = GetMonSetSize(monset); i < size; i++) {
    fprintf(stdout, ((i == 0) ? ("%lu") : (", %lu")), GetMonSetItem(monset, i));
  }
  fprintf(stdout, " >\n");

}

#endif DEBUG_MONSET
