// Copyright 1998,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#include "alloc.h"
#include "dassert.h"
#include "darray.h"
#include "ulhsort.h"


DARRAY *CreateDArray(void)
{
  DARRAY *darray;

  darray = (DARRAY *)xmalloc(sizeof(DARRAY));
  darray->ditems = (DARRAY_ELEMENT *)xmalloc(DARRAY_MINSIZE*
					     sizeof(DARRAY_ELEMENT));

  darray->curr_ditem = &darray->ditems[0];
  darray->last_ditem = &darray->ditems[DARRAY_MINSIZE -1];

  return darray;
}

void DeleteDArray(DARRAY *darray)
{

  free(darray->ditems);
  free(darray);

}

void ExpandDArray(DARRAY *darray)
{
  unsigned long curr;
  unsigned long new_size;

  // Double the new darraysize
  curr = (unsigned long)(darray->curr_ditem - &darray->ditems[0]);
  new_size = curr*2;

  darray->ditems = (DARRAY_ELEMENT *)xrealloc(darray->ditems,
					      (new_size *
					       sizeof(DARRAY_ELEMENT)));

  darray->curr_ditem = &darray->ditems[curr];
  darray->last_ditem = &darray->ditems[new_size -1];

}


void SortDArray(DARRAY *darray)
{
  unsigned long size;

  size = GetDArraySize(darray);
  if(size > 1) {
    ULHeapSort(&(darray)->ditems[0], size);
  }

}

