#ifndef BUCHI_H
#define BUCHI_H

#include <stdio.h>
#include "combi.h"
#include "bitarr.h"
#include "sarray.h"
#include "ulstack.h"

class PTNet;

typedef struct buchi_arc {
  unsigned long from_state;
  unsigned long to_state;
  SARRAY *pos;
  SARRAY *neg;
} BuchiArc;

class Buchi
{
public:

  Buchi(PTNet *net);
  ~Buchi();

  BOOL CanStutter(unsigned long transition_idx,
		  unsigned long num_places,
		  unsigned long *places);

  void AddArc(unsigned long transition_id,
	      unsigned long from,
	      unsigned long to,
	      BuchiArc *arc);

protected:

  BOOL CheckStuttering(unsigned long buchi_state,
		       BITARRAY *valuation);

  BOOL CheckTarjan(unsigned long buchi_state,
		   BITARRAY *valuation);

  unsigned long GetNextValuationRespectingSuccesor(unsigned long succ_num,
						   unsigned long s,
						   BITARRAY *valuation);

  BOOL SelfLoopsWithValuation(unsigned long s,
			      BITARRAY *valuation);
  
  unsigned long num_buchi_states;
  unsigned long num_buchi_trans;
  unsigned long num_atomic;
  unsigned long num_observables;

  unsigned long *place_mapping;

  unsigned long *observables;
  unsigned long *obs_atomic;
  char **obs_names;

  BITARRAY *default_negative_ap;

  PTNet *net;

  unsigned long *num_arcs;
  unsigned long *arc_offsets;
  BuchiArc *buchi_arcs;

  BITARRAY *accepting_states;

  BITARRAY *marked_bits;
  BITARRAY *modified_bits;

  UL_STACK *stack;
  UL_STACK *father_stack;

  unsigned long *min_numbers;
  
};

#endif /* BUCHI_H */

