// Copyright 1997, 1998 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef ALLOC_H
#define ALLOC_H

#include <stdio.h>
#include <stdlib.h>
#include "combi.h"

//#define DEBUG_MALLOC

#ifdef DEBUG_MALLOC
#include <dmalloc.h>
#endif /* DEBUG_MALLOC */

#define Allocate(x) malloc(x)
#define Deallocate(x) free(x)

#ifndef DEBUG_MALLOC

inline void *xmalloc(size_t size)

{
  void *ptr = malloc(size);
  if(ptr == NULL) {

    fprintf(stderr, "Out of memory in malloc, size %d\n", size);

    exit(1);
  }
  return ptr;
}

inline void *xrealloc(void *old, size_t size)

{
  void *ptr = realloc(old, size);
  if(ptr == NULL) {

    fprintf(stderr, "Out of memory in realloc, size %d\n", size);

    exit(1);
  }
  return ptr;
}

#endif /* DEBUG_MALLOC */

#endif ALLOC_H
