#include "dassert.h"
#include "ulhsort.h"

void ULHeapDownHeap(unsigned long *data,
		    unsigned long n,
		    unsigned long k)
{
  unsigned long j;
  unsigned long v;

  v = data[k];

  while((j = ((2*k) +1)) < n) {

    if((j < (n-1)) && (data[j] <= data[j +1])) {

      j++;

    }

    if(v >= data[j]) {

      break;

    }

    data[k] = data[j];
    k = j;
      
  }

  data[k] = v;
  
}



// Heap sort a table of unsigned long

void ULHeapSort(unsigned long *data, unsigned long size)
{
  unsigned long n;
  unsigned long k;
  unsigned long t;

  // Heap Sort - Guaranteed O(n log n) time
  
  if(size <= 1) {
    return;
  }

  n = size;

  for(k = (n/2); k > 0;) {

    k--;
    ULHeapDownHeap(data, n, k);

  }

  while(TRUE) {

    n--;
    t = data[0];
    data[0] = data[n];
    data[n] = t;

    if(n == 1) {
      break;
    }

    ULHeapDownHeap(data, n, 0);

  }

}


