#ifndef PTNET_H
#define PTNET_H

#include <stdio.h>
#include "combi.h"


typedef struct place {
  struct arc *preset;
  struct arc *postset;
  unsigned long id;
  char *name;
  char *meaning;
  unsigned long initial_marking;
} Place;


typedef struct transition {
  struct arc *preset;
  struct arc *postset;
  unsigned long id;
  char *name;
  char *meaning;
} Transition;


typedef struct arc {
  struct arc *nextplace;
  struct arc *nexttransition;
  struct place *place;
  struct transition *transition;
} Arc;


typedef struct alist {
  struct alist *next;
  struct arc *arc;
} Alist;


class PTNet
{
public:

  PTNet();
  ~PTNet();

  BOOL ReadPEP(FILE *in);

  Place **getPlaces(void) {return places;};
  Transition **getTransitions(void) {return transitions;};

  unsigned long getNumPlaces(void) {return numplaces;};
  unsigned long getNumTransitions(void) {return numtransitions;};
  unsigned long getNumArcs(void) {return numarcs;};

  char *getPlName(unsigned long id) {return places[id -1]->name;};
  char *getTrName(unsigned long id) {return transitions[id -1]->name;};
  unsigned long getPlId(char *name);

protected:

  BOOL insertPlace(unsigned long numname,
		   char *name,
		   char *meaning,
		   unsigned long initial_marking);
  BOOL insertTransition(unsigned long numname,
			char *name,
			char *meaning);
  BOOL insertTPArc(unsigned long transitionname,
		   unsigned long placename);
  BOOL insertPTArc(unsigned long placename,
		   unsigned long transitionname);
  void initPTNet(void);


  Place **places;
  Transition **transitions;
  Alist *alist;

  unsigned long numplaces;
  unsigned long numtransitions;
  unsigned long numarcs;

  Place **placesbyname;
  Transition **transitionsbyname;

  unsigned long maxplaces;
  unsigned long maxtransitions;


private:

  BOOL ReadLine(FILE *in);
  BOOL GetKeyword(const char *keyword);
  void RemoveComments(void);
  void SetCursor(char *newcursor) {cursor = newcursor;};
  BOOL isNumber(void);
  BOOL isString(void);
  int getNumber(void);
  char* getString(void);

  char *buf;
  char *cursor;

};

#define BUFSIZE 4097 /* The same as in PEP */


#endif /* PTNET_H */
