/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* list.c                    */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#include "list.h"

/**************************************************************************/
/* Liefert neuen Liste von Mengen (Set-List) mit dem einzigen             */
/* Listenelement 'set'.                                                   */
/* Bemerkung: Das erste Listenelement bleibt aus technischen Gruenden     */
/*            immer leer.                                                 */
/**************************************************************************/

SList *SListCreate(Set *set)
{
    SList *slist;

    assert(set);
    ((slist=(SList *)MyMalloc(sizeof(SList)))
     ->next=(SList *)MyMalloc(sizeof(SList)))->set=set;
    slist->next->next=NULL;
    slist->set=NULL;
    return slist;
}

/**************************************************************************/
/* Loeschen der Set-List 'slist'.                                         */
/**************************************************************************/

void SListDelete(SList *slist)
{
    SList *ptr;

    while (slist) {
        if (slist->set)
            SetDelete(slist->set);
        slist=(ptr=slist)->next;
        MyFree(ptr);
    }
}

/**************************************************************************/
/* Liefert ein Duplikat des Kopfes der Set-List 'slist'.                  */
/**************************************************************************/

SList *SListHeadDuplicate(SList *slist)
{
    SList *head;

    assert(slist);
    *(head=(SList *)MyMalloc(sizeof(SList)))=*slist;
    return head;
}

/**************************************************************************/
/* Ausgabe der Set-List 'slist'.                                          */
/**************************************************************************/

void SListDisplay(FILE *out,SList *slist)
{
    if (slist)
        while ((slist=slist->next)!=NULL) {
            SetDisplay(out,slist->set);
            fputc('\n',out);
        }
}

/**************************************************************************/
/* Einfuegen der Menge 'set' in die Set-List 'slist'.                     */
/**************************************************************************/

void SListNoTestInsert(SList *slist,Set *set)
{
    SList *new;

    assert(slist && set);
    (new=(SList *)MyMalloc(sizeof(SList)))->next=slist->next;
    (slist->next=new)->set=set;
}

/**************************************************************************/
/* Einfuegen der Menge 'set' in die Set-List 'slist'.                     */
/* Ist die Menge bereits enthalten, so wird 'set' geloescht               */
/* und '0' zurueckgegeben, sonst '1'.                                     */
/**************************************************************************/

int SListInsertElement(SList *slist,Set *set)
{
    SList *ptr;

    assert(slist && set);
    ptr=slist;
    for (;;) {
        if (ptr->next==NULL) {
            (ptr=ptr->next=(SList *)MyMalloc(sizeof(SList)))->next=NULL;
            ptr->set=set;
            return 1;
        }
        if (SetIsEqual(set,(ptr=ptr->next)->set)) {
            SetDelete(set);
            return 0;
        }
    }
}

/**************************************************************************/
/* Einfuegen der Menge 'set' in die Set-List 'slist'.                     */
/* Ist 'set'                                                              */
/*    - Obermenge einer bereits enthaltenen Menge 'x',                    */
/*      so wird 'x' durch 'set' ersetzt und 'x' geloescht.                */
/*    - Untermenge einer bereits enthaltenen Menge 'x',                   */
/*      so wird 'set' geloescht.                                          */
/* Rueckgabewert ist in diesen beiden Faellen '0'.                        */
/* Sonst wird 'set' am Anfang der Set-List eingefuegt                     */
/* und '1' zurueckgegeben.                                                */
/**************************************************************************/

int SListMaxInsert(SList *slist,Set *set)
{
    SList *ptr;

    assert(slist && set);
    ptr=slist;
    while ((ptr=ptr->next)!=NULL) {
        if (SetIsSubset(set,ptr->set)) {
            SetDelete(set);
            return 0;
        }
        if (SetIsSubset(ptr->set,set)) {
            SetDelete(ptr->set);
            ptr->set=set;
            return 0;
        }
    }
    (ptr=(SList *)MyMalloc(sizeof(SList)))->next=slist->next;
    (slist->next=ptr)->set=set;
    return 1;
}

/**************************************************************************/
/* Einfuegen der Menge 'set' in die Set-List 'slist'.                     */
/* Ist 'set'                                                              */
/*    - Obermenge einer bereits enthaltenen Menge 'x',                    */
/*      so wird 'set' geloescht.                                          */
/*    - Untermenge einer bereits enthaltenen Menge 'x',                   */
/*      so wird 'x' durch 'set' ersetzt und 'x' geloescht.                */
/* Rueckgabewert ist in diesen beiden Faellen '0'.                        */
/* Sonst wird 'set' am Anfang der Set-List eingefuegt                     */
/* und '1' zurueckgegeben.                                                */
/**************************************************************************/

int SListMinInsert(SList *slist,Set *set)
{
    SList *ptr;

    assert(slist && set);
    ptr=slist;
    while ((ptr=ptr->next)!=NULL) {
        if (SetIsSubset(set,ptr->set)) {
            SetDelete(ptr->set);
            ptr->set=set;
            return 0;
        }
        if (SetIsSubset(ptr->set,set)) {
            SetDelete(set);
            return 0;
        }
    }
    (ptr=(SList *)MyMalloc(sizeof(SList)))->next=slist->next;
    (slist->next=ptr)->set=set;
    return 1;
}

/**************************************************************************/
/* Liefert neue Liste von Paaren mit dem einzigen Listenelement '(x,y)'.  */
/* Diese Liste dient der Repraesentation eines Isomorphismus (I-List).    */
/**************************************************************************/

IList *IListCreate(unsigned x,unsigned y)
{
    IList *ilist;

    (ilist=(IList *)MyMalloc(sizeof(IList)))->next=NULL;
    ilist->x=x;
    ilist->y=y;
    return ilist;
}

/**************************************************************************/
/* Loeschen der I-List 'ilist'.                                           */
/**************************************************************************/

void IListDelete(IList *ilist)
{
    IList *ptr;

    assert(ilist);
    while (ilist) {
        ilist=(ptr=ilist)->next;
        MyFree(ptr);
    }
}

/**************************************************************************/
/* Einfuegen des Paares '(x,y)' in die I-List 'ilist'.                    */
/* Liefert '2', falls noch nicht vorhanden,                               */
/*         '1', falls schon vorhanden,                                    */
/*         '0', falls '(x,z)' vorhanden und 'z!=y' (kein Einfuegen !).    */
/* Bemerkung: Es wird davon ausgegangen, dass die Liste aufsteigend       */
/*            geordnet ist. Die Ordnung bleibt erhalten.                  */
/**************************************************************************/

void IListInsertElement(IList *ilist,unsigned x,unsigned y)
{
    IList *ptr;

    assert(ilist);
    do {
        ilist=(ptr=ilist)->next;
    } while (ilist && ilist->x<x);
    assert(!(ilist && ilist->x==x) || ilist->y==y);
    if (!ilist || ilist->x!=x) {
        (ptr=ptr->next=(IList *)MyMalloc(sizeof(IList)))->next=ilist;
        ptr->x=x;
        ptr->y=y;
    }
}

/**************************************************************************/
/* Ausgabe der I-List 'ilist'.                                            */
/**************************************************************************/

void IListDisplay(FILE *out,IList *ilist)
{
    while (ilist) {
        fprintf(out,"e%u->e%u\n",ilist->x,ilist->y);
        ilist=ilist->next;
    }
}

/**********************/
/* END OF FILE list.c */
/**********************/
