// Copyright 1998,1999,2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

////////////////////////////////////////////////////////////////////////
//
// Thanks to Burkhard for permission to use his code.
//
// This C++ code is based on the following C file (but heavily modified):
// (See subdirectory mci)
//
////////////////////////////////////////////////////////////////////////

/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* scanner.c                 */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#include <ctype.h>
#include <string.h>
#include "scanner.h"
#include "main.h"
#include "tree.h"
#include "ptnet.h"
#include "y_tab.h"

#define get(arg) (arg=getc(yyin_for_parser))
#define unget(arg) (ungetc(arg,yyin_for_parser))

/**************************************************************************/
/* Offensichtlich                                                         */
/**************************************************************************/

static int follow(int expect,int ifyes,int ifno)
{
    int c;

    if ((get(c))==expect)
        return ifyes;
    unget(c);
    return ifno;
}

/**************************************************************************/
/* Der Scanner                                                            */
/**************************************************************************/

int yylex(void)
{
    #define YYTEXT_SIZE 8192

    char *ptr,yytext[YYTEXT_SIZE];
    int i,c;

    for (;;) {
        get(c);
        if (isspace(c))
            continue;
        if (c=='_' || (isalpha(c) && c != 'F' && c != 'G' && c != 'U' && c != 'R')) {     /* Bezeichner */
            ptr=yytext; i=0;
            do {
                *ptr++=c;
                get(c);
            } while (++i<YYTEXT_SIZE && (c=='_' || c=='.' || isalnum(c)));
            unget(c);
            *ptr='\0';
            if ((yylval.wert=net_for_parser->getPlId(ptr-=i))==0) {
	      fprintf(stderr, "Scanner(): Placename: \"%s\" Unknown !\n", ptr);
	      exit(1);
	    }
            return PLACE;
        } else {
            switch (c) {
            case '-': return NOT;
            case '*': return AND;
            case '+': return OR;
            case 'F': return DIAMOND;
            case 'G': return BOX;
	    case 'U': return UNTIL;
	    case 'R': return RELEASE;
            case '=': return follow('>',IMPL,1);
            case '%':
                while (get(c)!='\n')
                    if (c==EOF)
                        return 0;
                break;
            case '.': return 0;
            case EOF: return 0;
            default:  return c;
            }
        }
    }
}


/*************************/
/* END OF FILE scanner.c */
/*************************/
