#include "unroll.h"
#include "combi.h"
#include "dassert.h"
#include "alloc.h"
#include "shash.h"
#include "smodels.h"
#include "api.h"
#include "ulhsort.h"
#include "tree2smo.h"
#include "set.h"

#define MAX(a,b) (((a) >= (b)) ? (a) : (b))
#define REMEMBER ((debugging != FALSE) || (do_formula != FALSE))

void unroll(PTNet *net,
	    unsigned long bound,
	    unsigned long semantics, // 0 = interleaved, 1 = step, 2 = process
	    BOOL do_deadlock,
	    BOOL do_formula,
	    TreeNode *formula,
	    BOOL debugging,
	    unsigned long optimize_level)

{
  unsigned long i;
  unsigned long j;
  unsigned long k;
  unsigned long placeidx;
  unsigned long transitionidx;
  Smodels *smodels;
  Api *api;
  Atom *atom;
  Atom *badlatom;
  Atom *atom1;
  Atom *atom2;
  
  Place **places;
  Transition **transitions;
  unsigned long numplaces;
  unsigned long numtransitions;

  unsigned long *tmpset;
  unsigned long tmpsize;

  unsigned long *created_rules;
  unsigned long *created;
  unsigned long *rule_start;
  unsigned long num_rules;
  unsigned long rule_size;
  unsigned long formula_num;
  unsigned long f_num;

  Arc *ac;
  Atom **placeatoms;
  Atom **transitionatoms;
  Atom **presets;
  Atom **fpresets;
  Atom *conflict_atom;
  Atom *live_atom;
  Atom *step_atom;
  Atom *noprocess_atom;

  SIMPLEHASH *hash;
  SET *vis_transitions;
  
  BOOL gotpreset;

  char buf[256];


  ASSERT((do_deadlock == FALSE) ||
	 (do_formula == FALSE));

  ASSERT((do_formula == FALSE) ||
	 (formula != NULL));

  ASSERT(bound > 0);

  smodels = new Smodels();
  api = new Api(&(smodels->program));

  if(do_formula != FALSE) {
    api->remember(); // Use Api lookup by name when checking formulas
  }

  numplaces = net->getNumPlaces();
  numtransitions = net->getNumTransitions();
  places = net->getPlaces();
  transitions = net->getTransitions();

  vis_transitions = (SET *)NULL;
  if(do_formula != FALSE) {
    if(semantics == 1) {
      vis_transitions = GetVisibleTransitions(formula, net);
    }
  }
  
  placeatoms = (Atom **)xmalloc((bound +1) * numplaces * sizeof(Atom *));
  transitionatoms = (Atom **)xmalloc(bound * numtransitions * sizeof(Atom *));
  presets = (Atom **)xmalloc(numplaces * sizeof(Atom *));

  fpresets = (Atom **)NULL;
  if(semantics == 2) {
    fpresets = (Atom **)xmalloc(numplaces * sizeof(Atom *)); // Atoms for process semantics
  }

  tmpset = (unsigned long *)xmalloc((MAX(numplaces, numtransitions)) * sizeof(unsigned long));
  tmpsize = 0;


  // TODO: replace numplaces*numtransitions with the number of place->transition arcs

  created_rules = (unsigned long *)xmalloc((numplaces + (numplaces * numtransitions)) *
					   sizeof(unsigned long));


  hash = (SIMPLEHASH *)NULL;
  if(optimize_level >= 2) {
    // The max number of conflict and liveness rules 
    hash = CreateSimpleHash(MAX(numplaces, numtransitions));
  }


  // Init all the special atoms used

  conflict_atom = (Atom *)NULL;
  live_atom = (Atom *)NULL;
  step_atom = (Atom *)NULL;
  noprocess_atom = (Atom *)NULL;


  // OK, first handle the time 0 places

  placeidx = 0;
  transitionidx = 0;

  for(j = 0; j < numplaces; j++, placeidx++) {

    ASSERT((places[j]->initial_marking == 0) ||
	   (places[j]->initial_marking == 1));

    placeatoms[placeidx] = (Atom *)NULL;
    presets[j] = (Atom *)NULL;

    if(semantics == 2) {
      fpresets[j] = (Atom *)NULL; // Clear the process semantics stuff
    }

    if((places[j]->initial_marking == 1) ||
       (optimize_level == 0)) {

      atom = api->new_atom();
      placeatoms[placeidx] = atom;
      presets[j] = atom;

      if(REMEMBER) {

	sprintf(buf, "p%ld(0)", places[j]->id);
	api->set_name(atom, buf);

      }

      if(places[j]->initial_marking == 1) {

	// Initially marked place

	api->begin_rule(BASICRULE);
	api->add_head(atom);
	api->end_rule();

      }


      if(semantics == 2) {

	// This is only for process semantics

	atom = api->new_atom();
	fpresets[j] = atom;

	if(REMEMBER) {

	  sprintf(buf, "fp%ld(0)", places[j]->id);
	  api->set_name(atom, buf);

	}

	if(places[j]->initial_marking == 1) {

	  // Initially marked place

	  api->begin_rule(BASICRULE);
	  api->add_head(atom);
	  api->end_rule();

	}

      }

    }

  }


  
  // OK, then handle all the rest of the timesteps
  // First init some special atoms when needed

  if(bound > 0) {
    conflict_atom = api->new_atom();
    if(REMEMBER) {
      api->set_name(conflict_atom, "conflict");
    }
  }

  if((semantics == 2) &&
     (bound > 0)) {
    noprocess_atom = api->new_atom();
    if(REMEMBER) {
      api->set_name(noprocess_atom, "noproc");
    }
  }



  for(i = 0; i < bound; i++) {


    // Rules for transitions, including presets

    for(j = 0; j < numtransitions; j++, transitionidx++) {

      transitionatoms[transitionidx] = (Atom *)NULL;

      gotpreset = TRUE;
      tmpsize = 0;
      for(ac = transitions[j]->preset;
	  ac != NULL;
	  ac = ac->nextplace) {

	if(presets[ac->place->id -1] == NULL) {
	  gotpreset = FALSE;
	} else {
	  tmpset[tmpsize] = ac->place->id;
	  tmpsize++;
	}
      }
      if(gotpreset == FALSE) {
	continue; // All preset atoms do not exist!
      }

      ASSERT(tmpsize != 0); // The transition preset should not be empty!


      // OK, all preset atoms exist

      if(semantics == 2) {

	// In process semantics also at least one of the preset places
	// should countain a fresh token

	gotpreset = FALSE;
	for(ac = transitions[j]->preset;
	    ac != NULL;
	    ac = ac->nextplace) {

	  if(fpresets[ac->place->id -1] != NULL) {
	    gotpreset = TRUE;
	    break;
	  }
	}
	if(gotpreset == FALSE) {
	  continue; // None of the preset atoms are fresh!
	}

      }


      // OK, the transition might exist, have to create it then


      atom = api->new_atom();
      transitionatoms[transitionidx] = atom;

      if(REMEMBER) {

	sprintf(buf, "t%ld(%ld)", transitions[j]->id, i);
	api->set_name(atom, buf);

      }

      ASSERT(tmpsize != 0);
      ULHeapSort(tmpset, tmpsize);

      api->begin_rule(CHOICERULE);
      api->add_head(atom);
      for(k = 0; k < tmpsize; k++) {
	api->add_body(presets[tmpset[k] -1], TRUE);
      }
      api->end_rule();


      if(semantics == 2) {

	// In process semantics at least one of the preset places must be fresh

	api->begin_rule(BASICRULE);	
	api->add_head(noprocess_atom);
	api->add_body(atom, TRUE);
	gotpreset = FALSE;
	for(k = 0; k < tmpsize; k++) {
	  if(fpresets[tmpset[k] -1] != NULL) {
	    api->add_body(fpresets[tmpset[k] -1], FALSE);
	    gotpreset = TRUE;
	  }
	}
	api->end_rule();

	ASSERT(gotpreset != FALSE);

      }

    }


    // Clear the process atoms in process semantics

    if(semantics == 2) {

      for(j = 0; j < numplaces; j++) {

	fpresets[j] = (Atom *)NULL;

      }

    }


    // Rules for postset places

    for(j = 0; j < numplaces; j++, placeidx++) {

      placeatoms[placeidx] = (Atom *)NULL;

      tmpsize = 0;
      for(ac = places[j]->preset;
	  ac != NULL;
	  ac = ac->nexttransition) {

	// (transitionidx - numtransitions) is the start of this round
        // transitions

	if(transitionatoms[(transitionidx-numtransitions) +
			  (ac->transition->id -1)] != NULL) {
	  tmpset[tmpsize] = ac->transition->id;
	  tmpsize++;
	}
      }      

      if(tmpsize == 0) { // Can this place be created?
	continue;
      }

      // OK, the place can be created
      ASSERT(tmpsize != 0);
      ULHeapSort(tmpset, tmpsize);


      atom = api->new_atom();
      placeatoms[placeidx] = atom;

      if(REMEMBER) {

	sprintf(buf, "p%ld(%ld)", places[j]->id, (i +1));
	api->set_name(atom, buf);

      }

      if(semantics == 2) {

	// Process semantics handles thing a bit differently

	fpresets[j] = api->new_atom();

	if(REMEMBER) {

	  sprintf(buf, "fp%ld(%ld)", places[j]->id, (i +1));
	  api->set_name(fpresets[j], buf);

	}

	// OK, we create one short rule here: p(i) :- fp(i)

	api->begin_rule(BASICRULE);
	api->add_head(atom);      
	api->add_body(fpresets[j], TRUE);
	api->end_rule();


	// Replace the atom p(i) with the atom fp(i) in
	// the rule created below

	atom = fpresets[j]; 

      }


      if(tmpsize == 1) {

	api->begin_rule(BASICRULE);

      } else {

	api->begin_rule(CONSTRAINTRULE);
	api->set_atleast_body(1);
      
      }

      api->add_head(atom);      

      for(k = 0; k < tmpsize; k++) {

	// (transitionidx - numtransitions) is the start of this round
        // transitions

	api->add_body(transitionatoms[(transitionidx-numtransitions) +
				     (tmpset[k] -1)],
		      TRUE);

      }

      api->end_rule();

    }
      


    // Rules for conflicts

    created = created_rules;
    num_rules = 0;

    // Clear the hash table from last round stuff
    if((i > 0) && (optimize_level >= 2)) {
      ClearSimpleHash(hash);
    }

    for(j = 0; j < numplaces; j++) {

      if(presets[j] == NULL) { // The place does not exist, neither does the conflict
	continue;
      }

      tmpsize = 0;
      for(ac = places[j]->postset;
	  ac != NULL;
	  ac = ac->nexttransition) {

	if(transitionatoms[(transitionidx-numtransitions)+
			  (ac->transition->id -1)] != NULL) {
	  tmpset[tmpsize] = ac->transition->id;
	  tmpsize++;
	}

      }      

      if(tmpsize < 2) { // Conflict requires at least two transitions
	continue;
      }

      ASSERT(tmpsize != 0);
      ULHeapSort(tmpset, tmpsize);


      // Rules are stored as: <bodysize, body1, body2, ..., bodyn>

      rule_start = created;

      *created++ = tmpsize;
      for(k = 0; k < tmpsize; k++) {
	*created++ = tmpset[k];
      }

      if(optimize_level >= 2) {

	if(InsertDataTellIfNew(hash, rule_start) == FALSE) {

	  // This is a duplicate of some earlier rule.
	  // Try to generate a new one with better luck.
          
	  created = rule_start;
	  continue;

	}
	
      }

      num_rules++;

    }

    // OK, here should come the duplicate conflict rule removal, TODO: Implement!

    if(optimize_level >= 2) {

      // Duplicate rule removal only at levels >= 2



    }

    // OK, feed the conflict rules to smodels

    created = created_rules;

    for(j = 0; j < num_rules; j++) {

      rule_size = *created++;

      if(rule_size == 2) {

	api->begin_rule(BASICRULE);

      } else {

	api->begin_rule(CONSTRAINTRULE);
	api->set_atleast_body(2);
      
      }

      api->add_head(conflict_atom);

      for(k = 0; k < rule_size; k++) {

	// (transitionidx - numtransitions) is the start of this round
        // transitions

	api->add_body(transitionatoms[(transitionidx-numtransitions)+
	((*created++) -1)] , TRUE);
      }

      api->end_rule();

    }



    // Frame axioms for the next round

    for(j = 0; j < numplaces; j++) {

      if(presets[j] == NULL) {

	// The place was not preset last round, so no frame axiom
	// is needed.

	// OK, the presets of the next round are the place
	// atoms of the current round

	presets[j] = placeatoms[(placeidx-numplaces) + j];
	continue;

      }

      // The place was preset last round, thus it needs a frame axiom

      if(placeatoms[(placeidx-numplaces) + j] == NULL) {

	// The place can only be created by the frame axiom,
	// so create the place atom here

	atom = api->new_atom();

	placeatoms[(placeidx-numplaces) + j] = atom;

	if(REMEMBER) {

	  sprintf(buf, "p%ld(%ld)", places[j]->id, (i +1));
	  api->set_name(atom, buf);

	}

      }


      // Get the existing transitions which can remove the token from this place

      tmpsize = 0;
      for(ac = places[j]->postset;
	  ac != NULL;
	  ac = ac->nexttransition) {

	if(transitionatoms[(transitionidx-numtransitions)+
			  (ac->transition->id -1)] != NULL) {
	  tmpset[tmpsize] = ac->transition->id;
	  tmpsize++;
	}

      }

      if(tmpsize > 1) {
	ULHeapSort(tmpset, tmpsize);
      }

      atom = placeatoms[(placeidx-numplaces) + j];
	
      api->begin_rule(BASICRULE);
      api->add_head(atom);

      api->add_body(presets[j], TRUE); // Last round place

      for(k = 0; k < tmpsize; k++) {
	api->add_body(transitionatoms[(transitionidx-numtransitions) +
				     (tmpset[k] -1)],
		      FALSE); // Post transitions as negative
      }

      api->end_rule();


      // OK, the presets of the next round are the place
      // atoms of the current round

      presets[j] = atom;

    }    



    // Add interleaving force constraints if wanted and there
    // are any timesteps

    if(semantics == 0) {

      if(i == 0) {

	// Create the step atom on the first round

	step_atom = api->new_atom();
	if(REMEMBER) {
	  api->set_name(step_atom, "step");
	}

      }


      // If two or more transitions of a step are present,
      // we will get a step. (Models with the step atom
      // will later be excluded from the set of stable models.)


      api->begin_rule(CONSTRAINTRULE);
      api->set_atleast_body(2);
      api->add_head(step_atom);

      for(j = 0; j < numtransitions; j++) {

	if(transitionatoms[(transitionidx-numtransitions) +j] != NULL) {

	  api->add_body(transitionatoms[(transitionidx-numtransitions) +j], TRUE);

	}

      }

      api->end_rule();

    }


    if(do_formula != FALSE) {

      if(semantics == 2) {
	ASSERT(FALSE); // Not implemented for processes
      }

      if(semantics == 1) {

	// Step semantics visibility handling
	
	tmpsize = 0;
	for(j = 0; j < numtransitions; j++) {
	  if(transitionatoms[(transitionidx-numtransitions) +j] != NULL) {

	    // OK, the transition j exists, check if it is visible
	    if(InSet(vis_transitions, j)) {
	      tmpsize++;
	    }
	  }
	}

	if(tmpsize > 1) {

	  // There might be more that two visible transitions enabled, remove
	  // models containing more than two visible transitions
	  
	  api->begin_rule(CONSTRAINTRULE);
	  api->set_atleast_body(2);
	  atom = api->get_atom("two_vis");
	  if(atom == NULL) {
	    atom = api->new_atom();
	    api->set_name(atom, "two_vis");
	    api->set_compute(atom, FALSE);
	  }
	  api->add_head(atom);

	  for(j = 0; j < numtransitions; j++) {

	    if(transitionatoms[(transitionidx-numtransitions) +j] != NULL) {

	      if(InSet(vis_transitions, j)) {
		api->add_body(transitionatoms[(transitionidx-numtransitions) +j], TRUE);
	      }
	      
	    }

	  }

	  api->end_rule();
	  
	}

      }

    }

  }


  ASSERT(placeidx == ((bound +1) * numplaces));
  ASSERT(transitionidx == (bound * numtransitions));


  // Add deadlock checking rules if requested

  if(do_deadlock != FALSE) {

    live_atom = api->new_atom();
    if(debugging != FALSE) {
      api->set_name(live_atom, "live");
    }


    // OK, we're kinda adding a new level of transitions
    // here...

    // Rules for liveness

    created = created_rules;
    num_rules = 0;

    // Clear the hash table from last round stuff
    if((bound > 0) && (optimize_level >= 2)) {
      ClearSimpleHash(hash);
    }

    for(j = 0; j < numtransitions; j++) {

      gotpreset = TRUE;
      tmpsize = 0;
      for(ac = transitions[j]->preset;
	  ac != NULL;
	  ac = ac->nextplace) {

	if(presets[ac->place->id -1] == NULL) {
	  gotpreset = FALSE;
	} else {
	  tmpset[tmpsize] = ac->place->id;
	  tmpsize++;
	}
      }
      if(gotpreset == FALSE) {
	continue; // All preset atoms do not exist!
      }

      // OK, all preset atoms exist, have to create the liveness constraint

      ASSERT(tmpsize != 0);
      ULHeapSort(tmpset, tmpsize);


      // Rules are stored as: <bodysize, body1, body2, ..., bodyn>

      rule_start = created;

      *created++ = tmpsize;
      for(k = 0; k < tmpsize; k++) {
	*created++ = tmpset[k];
      }

      if(optimize_level >= 2) {

	if(InsertDataTellIfNew(hash, rule_start) == FALSE) {

	  // This is a duplicate of some earlier rule.
	  // Try to generate a new one with better luck.
          
	  created = rule_start;
	  continue;

	}
	
      }

      num_rules++;

    }


    // Feed the liveness rules to smodels

    created = created_rules;

    for(j = 0; j < num_rules; j++) {

      api->begin_rule(BASICRULE);
      api->add_head(live_atom);

      rule_size = *created++;
      for(k = 0; k < rule_size; k++) {
	api->add_body(presets[(*created++) -1], TRUE);
      }
      api->end_rule();

    }


    api->set_compute(live_atom, FALSE);

  }


  // Add formula if requested

  if(do_formula != FALSE) {

    ASSERT(semantics != 2); // No process semantics with formulas (not implemented)

    atom = api->new_atom();
    api->set_name(atom, "l");

    if(bound > 0) {

      atom = api->new_atom();
      api->set_name(atom, "badloop");
      api->set_compute(atom, FALSE);

      // Add the loop guess:
      // { el(0), el(1), ..., el(n-1) } :-

      api->begin_rule(CHOICERULE);

      for(i = 0; i < bound; i++) {

	atom = api->new_atom();
	sprintf(buf, "el(%ld)", i);
	api->set_name(atom, buf);
	api->add_head(atom);

      }

      api->end_rule();


      // Add the rule which forbids looping twice.
      // badloop :- 2 { el(0), el(1), ..., el(n-1) }

      api->begin_rule(CONSTRAINTRULE);
      api->set_atleast_body(2);
      atom = api->get_atom("badloop");
      ASSERT(atom != NULL);
      api->add_head(atom);

      for(i = 0; i < bound; i++) {

	sprintf(buf, "el(%ld)", i);
	atom = api->get_atom(buf);
	ASSERT(atom != NULL);
	api->add_body(atom, TRUE);

      }

      api->end_rule();


      // Add the loop rules:
      // l :- el(i)
      // nl(i + 1) :- el(i)
      //
      // where 0 <= i <= n-1

      for(i = 0; i < bound; i++) {

	api->begin_rule(BASICRULE);
	atom = api->get_atom("l");
	ASSERT(atom != NULL);
	api->add_head(atom);
	atom = api->new_atom();
	sprintf(buf, "el(%ld)", i);
	atom = api->get_atom(buf);
	api->add_body(atom, TRUE);
	api->end_rule();

	api->begin_rule(BASICRULE);
	atom = api->new_atom();
	sprintf(buf, "nl(%ld)", (i+1));
	api->set_name(atom, buf);
	api->add_head(atom);
	atom = api->new_atom();
	sprintf(buf, "el(%ld)", i);
	atom = api->get_atom(buf);
	api->add_body(atom, TRUE);
	api->end_rule();

      }


      // Add the rule:
      // If loop, then last step is non-empty
      // badloop :- l, not t_1(bound-1),... , not t_n(bound -1)

      api->begin_rule(BASICRULE);
      atom = api->get_atom("badloop");
      ASSERT(atom != NULL);
      api->add_head(atom);
      atom = api->get_atom("l");
      ASSERT(atom != NULL);
      api->add_body(atom, TRUE);
      for(j = 0; j < numtransitions; j++) {
	sprintf(buf, "t%ld(%ld)", (j+1), (bound -1));
	atom = api->get_atom(buf);
	if(atom != NULL) {
	  // Add only ones which have not been optimized away
	  api->add_body(atom, FALSE);
	}
      }
      api->end_rule();


      // Add the stuff which requires that the marking being looped
      // to equals the final marking.
      //
      // badloop :- el(i), p(i), not p(bound)
      // badloop :- el(i), not p(i), p(bound)

      badlatom = api->get_atom("badloop");
      ASSERT(badlatom != NULL);

      for(i = 0; i < bound; i++) {

	sprintf(buf, "el(%ld)", i);
	atom = api->get_atom(buf);
	ASSERT(atom != NULL);

	for(j = 0; j < numplaces; j++) {

	  sprintf(buf, "p%ld(%ld)", (j+1) , i);
	  atom1 = api->get_atom(buf);

	  sprintf(buf, "p%ld(%ld)", (j+1) , bound);
	  atom2 = api->get_atom(buf);

	  if(atom1 == NULL) {

	    if(atom2 == NULL) {
	      // Neither atom exists, nothing to add
	      ;
	    } else {
	      // Only the last one exists, stuff differs if it has a token
	      api->begin_rule(BASICRULE);
	      api->add_head(badlatom);
	      api->add_body(atom, TRUE);
	      api->add_body(atom2, TRUE);
	      api->end_rule();
	    }

	  } else {

	    if(atom2 == NULL) {
	      // Only the first one exists, stuff differs if it has a token
	      api->begin_rule(BASICRULE);
	      api->add_head(badlatom);
	      api->add_body(atom, TRUE);
	      api->add_body(atom1, TRUE);
	      api->end_rule();
	    } else {
	      // Both atoms exist, add both rules
	      api->begin_rule(BASICRULE);
	      api->add_head(badlatom);
	      api->add_body(atom, TRUE);
	      api->add_body(atom1, TRUE);
	      api->add_body(atom2, FALSE);
	      api->end_rule();
	      api->begin_rule(BASICRULE);
	      api->add_head(badlatom);
	      api->add_body(atom, TRUE);
	      api->add_body(atom1, FALSE);
	      api->add_body(atom2, TRUE);
	      api->end_rule();
	    }

	  }

	}

      }


      if(FormulaHasBoxOrRelease(formula)) {

	// Create a set of atoms il(x) telling that time x belongs to the loop

	for(i = 0; i < bound; i++) {
	
	  // il(i+1) :- el(i)
	  // il(i+1) :- il(i), when i > 0

	  api->begin_rule(BASICRULE);
	  atom = api->new_atom();
	  sprintf(buf, "il(%ld)", (i+1));
	  api->set_name(atom, buf);
	  api->add_head(atom);
	  sprintf(buf, "el(%ld)", i);
	  atom = api->get_atom(buf);
	  ASSERT(atom != NULL);
	  api->add_body(atom, TRUE);
	  api->end_rule();

	  if(i != 0) {
	    api->begin_rule(BASICRULE);
	    sprintf(buf, "il(%ld)", (i+1));
	    atom = api->get_atom(buf);
	    ASSERT(atom != NULL);
	    api->add_head(atom);
	    sprintf(buf, "il(%ld)", i);
	    atom = api->get_atom(buf);
	    ASSERT(atom != NULL);
	    api->add_body(atom, TRUE);
	    api->end_rule();
	  }

	}

      }


    }

    formula_num = 0;
    f_num = Tree2Smo(formula, &formula_num, api, bound);
    sprintf(buf, "f%ld(0)", f_num);
    atom = api->get_atom(buf);
    ASSERT(atom != NULL);
    
    api->set_compute(atom, TRUE);

  }


  if(bound > 0) {
    api->set_compute(conflict_atom, FALSE);
  }  

  if((semantics == 0) &&
     (bound > 0)) {
    api->set_compute(step_atom, FALSE);
  }

  if((semantics == 2) &&
     (bound > 0)) {
    api->set_compute(noprocess_atom, FALSE);
  }


  api->done();

  if(debugging != FALSE) {

    smodels->program.print();

  }


  if(hash != NULL) {
    DeleteSimpleHash(hash);
  }

  free(created_rules);
  free(tmpset);
  if(fpresets != NULL) {
    free(fpresets);
  }
  free(presets);
  free(transitionatoms);
  free(placeatoms);

  if(do_formula != FALSE) {
    if(semantics == 1) {
      DeleteSet(vis_transitions);
    }
  }

  
  return;

}

#if 0
void insertionSort(unsigned long n, unsigned long *a)
{
  unsigned long i;
  unsigned long j;
  unsigned long v;

  // Good old insertion sort.
  //
  // It is linear time for already sorted sequences.
  //
  // (And quadratic for sequences in the worst case.)

  
  if(n < 2) {
    return;
  }
  
  for(i = 1; i < n; i++) {

    v = a[i];
    j = i;

    while (j != 0 && a[j -1] > v) {
      a[j] = a[j -1];
      j--;
    }

    a[j] = v;
    
  }

}
#endif


#undef REMEMBER
#undef MAX

