// Copyright 2000 by Keijo Heljanko
// This software is provided as is, no warranty of any kind is given.

#ifndef SET_H
#define SET_H

#include "combi.h"
#include "bitarr.h"

typedef unsigned long SET_ITEM;

typedef struct sset
{
  BITARRAY *setbits;       /* Set membership bits at even locations,
                              set cleaning bits at odd locations. */
  SET_ITEM *curr_item;
  BOOL dirty_set;          /* Have any removes been done to the set? */
  SET_ITEM set_items[1];
} SET;


#define AddtoSet(sset, item) \
(SetBit((sset)->setbits, ((item)*2)), \
 (GetBit((sset)->setbits, (((item)*2)+1)) ? \
  (TRUE) : \
  (SetBit((sset)->setbits, (((item)*2)+1)), \
   *(sset)->curr_item++ = (item))))

#define RemovefromSet(sset, item) \
(ClearBit((sset)->setbits, ((item)*2)), \
 (sset)->dirty_set = TRUE)

#define EmptySet(sset) \
(((sset)->dirty_set == FALSE) ? \
 (((sset)->curr_item == (&(sset)->set_items[0])) ? \
  (TRUE) : (FALSE)) : \
 (DirtyEmptySet(sset)))

#define GetSetSize(sset) \
(((sset)->dirty_set == FALSE) ? \
 ((unsigned long)((sset)->curr_item - (&(sset)->set_items[0]))) : \
 (DirtyGetSetSize(sset)))

#define GetSetItem(sset, index) \
((sset)->set_items[(index)])

#define InSet(sset, item) \
(GetBit((sset)->setbits, ((item)*2)))


SET *CreateSet(unsigned long domainsize);
void DeleteSet(SET *sset);

void ClearSet(SET *sset);


void SortSet(SET *sset);

/* For internal use only! */

unsigned long DirtyGetSetSize(SET *sset);
BOOL DirtyEmptySet(SET *sset);

#endif /* SET_H */
