/*
 * Copyright Burkhard Graves, PEP project, University of Hildesheim
 * See: http://www.informatik.uni-hildesheim.de/~pep/HomePage.html 
 */

/*****************************/
/* occ_net.h                 */
/* Burkhard Graves, 26.10.94 */
/*****************************/

#ifndef __OCC_NET_H__
#define __OCC_NET_H__

#include "main.h"
#include "list.h"
#include "set.h"

/*******************/
/* Typdefinitionen */
/*******************/

typedef struct Wanted_ {
    struct Wanted_ *next;              /* naechster Gesuch                  */
    unsigned        base;              /*                                   */
    unsigned        broken;            /*                                   */
    unsigned        count;             /*                                   */
} Wanted;

/*-------------------------*/
/* virtuelles Cutoff-Event */
/*-------------------------*/

typedef struct VCEvnt_ {
    struct VCEvnt_ *next;              /* naechstes virtuelles Cutoff-Event */
    unsigned        numname;           /* Numerischer Name                  */
    Set            *causes_corr_event; /* Geschichte des korresp. Events    */
    Set            *causes_event;      /* Geschichte des Cutoff-Events      */
    IList          *ilist;             /* Zeiger auf Isomorphismus          */
} VCEvent;

/*---------------------------------------------*/
/* Zusatz-Informationen fuer die Cutoff-Events */
/*---------------------------------------------*/

typedef struct Info_ {
    unsigned  corr_event;           /* korrespondierendes Event         */
    Set      *causes_corr_event;    /* Geschichte des korresp. Events   */
    Set      *causes_event;         /* Geschichte des Cutoff-Events     */
    IList    *ilist;                /* Zeiger auf Isomorphismus         */
} Info;

/*--------------------*/
/* Bedingung (Stelle) */
/*--------------------*/

typedef struct Cond_ {
    struct Cond_ *next;       /* Zeiger auf naechste Bedingung           */
    struct Edge_ *preset;     /* Zeiger auf erste Kante des Vorbereichs  */
    struct Edge_ *postset;    /*   bzw. des Nachbereichs                 */
    unsigned      numname;    /* Numerischer Name                        */
    unsigned      pl_numname; /* Numerischer Name der entspr. Stelle     */
} Condition;

/*-----------------------*/
/* Ereignis (Transition) */
/*-----------------------*/

typedef struct Evnt_ {
    struct Evnt_ *next;       /* Zeiger auf naechstes Ereignis           */
    struct Edge_ *preset;     /* Zeiger auf erste Kante des Vorbereichs  */
    struct Edge_ *postset;    /*   bzw. des Nachbereichs                 */
    Info         *info;       /* Informationen, falls Cutoff-Event       */
    unsigned      numname;    /* Numerischer Name                        */
    unsigned      tr_numname; /* Numerischer Name der entspr. Transition */
} Event;

/*-------*/
/* Kante */
/*-------*/

typedef struct Edge_ {
    struct Edge_ *nextcondition;    /* vertikale Verkettung     */
    struct Edge_ *nextevent;        /* horizontale Verkettung   */
    Condition    *condition;        /* Zeiger auf Bedingung     */
    Event        *event;            /* Zeiger auf Ereignis      */
} Edge;

/*-------------------*/
/* Kopf eines Netzes */
/*-------------------*/

typedef struct {
    Condition *conditions;     /* Zeiger auf Liste von Bedingungen       */
    Event     *events;         /* Zeiger auf Liste von Ereignissen       */
    VCEvent   *vcevents;       /* Zeiger auf Liste von virtuellen Events */
    unsigned   num_conditions; /* Anzahl der Bedingungen                 */
    unsigned   num_events;     /* Anzahl der Ereignisse                  */
    unsigned   num_vce;        /* Anzahl der virtuellen Ereignisse       */
} BraProcess;

/****************************/
/* Externe globale Variable */
/****************************/

extern char **pl_names;
extern char **tr_names;
extern char *names;

/**************/
/* Prototypen */
/**************/

void DeleteBraProcess PROTO ((BraProcess *bprocess));
unsigned GetPlNumname PROTO ((char *ptr));
char       *GetPlName PROTO ((unsigned numname));
unsigned GetTrNumname PROTO ((char *ptr));
char       *GetTrName PROTO ((unsigned numname));
void      ReadMciFile PROTO ((FILE *in));

#endif

/*************************/
/* END OF FILE occ_net.h */
/*************************/
