#include <stdio.h>
#include "combi.h"
#include "dassert.h"
#include "alloc.h"
#include "set.h"
#include "monset.h"
#include "unroll.h"

#define NEVER_BOTH_GENERATE_AND_FRAME

// First some routines to print the same stuff in two different syntaxes

inline void assign_begin(BOOL do_relation)
{
  if(do_relation == FALSE) {
    printf("SET{");
  } else {
    printf("ASSIGN {");
  }
}

inline void assign_end(BOOL do_relation)
{
  if(do_relation == FALSE) {
    printf("};\n");
  } else {
    printf("};\n");
  }
}

inline void print_prev(BOOL do_relation, char *name, unsigned long number, unsigned long round)
{
  if(do_relation == FALSE) {
    printf("%s%lu_%lu", name, number, (round-1));
  } else {
    printf("%s%lu", name, number);
  }
}

inline void print_prev_nonum(BOOL do_relation, char *name, unsigned long round)
{
  if(do_relation == FALSE) {
    printf("%s_%lu", name, (round-1));
  } else {
    printf("%s", name);
  }
}

inline void print_curr(BOOL do_relation, char *name, unsigned long number, unsigned long round)
{
  if(do_relation == FALSE) {
    printf("%s%lu_%lu", name, number, round);
  } else {
    printf("%s%lu'", name, number);
  }
}

inline void print_curr_nonum(BOOL do_relation, char *name, unsigned long round)
{
  if(do_relation == FALSE) {
    printf("%s_%lu", name, round);
  } else {
    printf("%s'", name);
  }
}



void unroll(PTNet *net,
	    unsigned long bound,
	    unsigned long semantics, // 0 = interleaved, 1 = step, 2 = process
	    unsigned long optimize_level,
	    BOOL do_deadlock,
	    BOOL do_formula,
	    BOOL do_relation,
	    BOOL do_no_idle)
#if 0	    
	    TreeNode *formula)
#endif

{
  unsigned long i;
  unsigned long j;
  unsigned long k;
  unsigned long t;
  unsigned long size;
  unsigned long size2;
  unsigned long gentran;
  BOOL first;
  BOOL r;
  BOOL gpfound;
  BOOL enabled;
  
  Place **places;
  Transition **transitions;
  unsigned long numplaces;
  unsigned long numtransitions;

  Arc *ac;
  SET *tset;
  MONSET *gpset;

  MONSET *p_prev;
  MONSET *p_curr;
  MONSET *gp_prev;
  MONSET *gp_curr;

  MONSET *t_prev;

  MONSET *t1;
  MONSET *p1;

  t = 0;
  size = 0;
  size2 = 0;
  gentran = 0;

  if(do_relation != FALSE) {
    // Relation implemented by unrolling by one
    bound = 1;
  }

  ASSERT(bound > 0); // Bound = 0 not implemented
  ASSERT((do_deadlock == FALSE) || (do_relation == FALSE)); // Deadlock checking not implemented in relation
  


  // Get the net

  numplaces = net->getNumPlaces();
  numtransitions = net->getNumTransitions();
  places = net->getPlaces();
  transitions = net->getTransitions();

  // TODO: Also handle the following special cases
  ASSERT(numplaces != 0);
  ASSERT(numtransitions != 0);

  tset = CreateSet(numtransitions);
  ASSERT(tset != NULL);
  gpset = CreateMonSet(numplaces);
  ASSERT(gpset != NULL);

  p_prev = CreateMonSet(numplaces);
  ASSERT(p_prev != NULL);
  p_curr = CreateMonSet(numplaces);
  ASSERT(p_curr != NULL);
  gp_prev = CreateMonSet(numplaces);
  ASSERT(gp_prev != NULL);
  gp_curr = CreateMonSet(numplaces);
  ASSERT(gp_curr != NULL);

  t_prev = CreateMonSet(numtransitions);
  ASSERT(t_prev != NULL);


  // Create some temporary sets

  t1 = CreateMonSet(numtransitions);
  ASSERT(t1 != NULL);

  p1 = CreateMonSet(numplaces);
  ASSERT(p1 != NULL);

  
  r = do_relation;
  
  if(r != FALSE) {

    printf("SVAR ");
    for(j = 0, first = TRUE; j < numplaces; j++) {

      if(first == FALSE) {
	printf(", ");
      }
      first = FALSE;

      print_prev(r, "p", j, 1);

    }
    printf(";\n");


    // The generate vars are state vars in process semantics
    
    if(semantics == 2) {
      printf("SVAR ");
      
      for(j = 0, first = TRUE; j < numplaces; j++) {

	if(first == FALSE) {
	  printf(", ");
	}
	first = FALSE;

	print_prev(r, "gp", j, 1);

      }
      printf(";\n");

    }
    
    // Transition variables are always input vars
    
    printf("IVAR ");
    for(j = 0, first = TRUE; j < numtransitions; j++) {

      if(first == FALSE) {
	printf(", ");
      }
      first = FALSE;

      print_prev(r, "t", j, 1);

    }
    printf(";\n");
    
    printf("\n//********************************************************\n");
    printf("TRANSITION RELATION\n\n");
    
  }


  // Calculate which place gates are needed on the first level

  if((optimize_level == 0) || (r != FALSE)) {

    // Relation required or no-optimize mode

    for(j = 0; j < numplaces; j++) {

      AddtoMonSet(p_prev, j);

    }

  } else {

    for(j = 0; j < numplaces; j++) {

      ASSERT((places[j]->initial_marking == 0) ||
	     (places[j]->initial_marking == 1));

      if(places[j]->initial_marking == 1) {
	AddtoMonSet(p_prev, j);
      }

    }

  }


  // All gp gates are required anyway

  for(j = 0; j < numplaces; j++) {

    AddtoMonSet(gp_prev, j);

  }


  
  // Unroll the transition relation
  
  for(i = 1; i <= bound; i++) {

    // Calculate which transitions can be enabled on this
    // level

    if((optimize_level == 0) || (r != FALSE)) {

      // No optimize or relation, all generated

      for(j = 0; j < numtransitions; j++) {
	AddtoMonSet(t_prev, j);
      }

    } else {

      for(j = 0; j < numtransitions; j++) {

	// Check that all preset tokens can be generated an at least one
	// of then was generated in the previous level


	// Empty presets are not allowed!

	ASSERT(transitions[j]->preset != NULL);

	for(ac = transitions[j]->preset, enabled = TRUE, gpfound = FALSE;
	    ac != NULL;
	    ac = ac->nextplace) {

	  t = (ac->place->id -1);

	  if(!InMonSet(p_prev, t)) {
	    enabled = FALSE;
	    break;
	  }

	  if(gpfound == TRUE) {
	    continue;
	  }

	  if(InMonSet(gp_prev, t)) {
	    gpfound = TRUE;
	  }

	}

	if((semantics == 2) && (gpfound == FALSE)) {

	  // The gp gates disable enabledness only in process semantics

	  enabled = FALSE;

	}

	// If the transition can be enabled in this step, enabled is TRUE

	if(enabled != FALSE) {

	  AddtoMonSet(t_prev, j);

	}

      }

    }


    // Update the place gates that are needed on the next. First add previous places.
    // (Places are monotonic.)

    for(j = 0; j < numplaces; j++) {

      if(InMonSet(p_prev, j)) {

	AddtoMonSet(p_curr, j);

      }

    }

    // Then add places corresponding to postsets of (possibly) enabled transitions.
    // Also add the next level gp gates while at it. (They are NOT monotonic!)


    for(j = 0; j < numtransitions; j++) {

      if(!InMonSet(t_prev, j)) {
	continue;
      }

      for(ac = transitions[j]->postset;
	  ac != NULL;
	  ac = ac->nextplace) {

	t = (ac->place->id -1);
	AddtoMonSet(p_curr, t);
	AddtoMonSet(gp_curr, t);

      }

    }
 

    if((optimize_level == 0) || (r != FALSE)) {

      // No optimize or relation, all generated

      for(j = 0; j < numplaces; j++) {

	AddtoMonSet(gp_curr, j);

      }

    }


#if 0

    // Some optimization debugging output


    printf("// Optimization debug stuff:\n");

    printf("// P_%lu = {", (i-1));

    for(j = 0, first = TRUE; j < numplaces; j++) {

      if(!InMonSet(p_prev, j)) {
	continue;
      }

      if(first != TRUE) {
	printf(", ");
      }
      first = FALSE;

      printf("p%lu", j);

    }

    printf("}\n");

    printf("// GP_%lu = {", (i-1));
    for(j = 0, first = TRUE; j < numplaces; j++) {

      if(!InMonSet(gp_prev, j)) {
	continue;
      }

      if(first != TRUE) {
	printf(", ");
      }
      first = FALSE;

      printf("gp%lu", j);

    }

    printf("}\n");


    printf("// T_%lu = {", (i-1));
    for(j = 0, first = TRUE; j < numtransitions; j++) {

      if(!InMonSet(t_prev, j)) {
	continue;
      }

      if(first != TRUE) {
	printf(", ");
      }
      first = FALSE;

      printf("t%lu", j);

    }

    printf("}\n");


    printf("// P'_%lu = {", i);
    for(j = 0, first = TRUE; j < numplaces; j++) {

      if(!InMonSet(p_curr, j)) {
	continue;
      }

      if(first != TRUE) {
	printf(", ");
      }
      first = FALSE;

      printf("p'%lu", j);

    }

    printf("}\n");

    printf("// GP'_%lu = {", i);
    for(j = 0, first = TRUE; j < numplaces; j++) {

      if(!InMonSet(gp_curr, j)) {
	continue;
      }

      if(first != TRUE) {
	printf(", ");
      }
      first = FALSE;

      printf("gp'%lu", j);

    }

    printf("}\n");


#endif

    // The transition preset circuit is created
    
    for(j = 0; j < numtransitions; j++) {

      // Create only transitions which can (possibly) be enabled in this step

      if(!InMonSet(t_prev, j)) {
	continue;
      }

      size = 0;
      size2 = 0;

      ASSERT(transitions[j]->preset != NULL);

      print_prev(r, "tt", j, i);
      printf(" := OR {~");
      print_prev(r, "t", j, i);
      printf(", ");
      if((transitions[j]->preset->nextplace != NULL) ||
	 ((semantics == 2) && ((optimize_level == 0) || (r != FALSE) || (i > 1)))) {
	printf("AND {");
      }
      
      for(ac = transitions[j]->preset, first = TRUE;
	  ac != NULL;
	  ac = ac->nextplace) {

	if(first == FALSE) {
	  printf(", ");
	}
	first = FALSE;

	t = (ac->place->id -1);
	ASSERT(InMonSet(p_prev, t));

	print_prev(r, "p", t, i);
	
      }


      if((semantics == 2) && ((optimize_level == 0) || (r != FALSE) || (i > 1))){

	printf(", ");

	ClearMonSet(p1);
	for(ac = transitions[j]->preset;
	    ac != NULL;
	    ac = ac->nextplace) {

	  t = (ac->place->id -1);
	  if(InMonSet(gp_prev, t)) {
	    AddtoMonSet(p1,t);
	  }

	}
	size = GetMonSetSize(p1);
	ASSERT(size != 0);

	if(size > 1) {
	  printf("OR {");
	}

	for(k = 0, first = TRUE; k < size; k++) {

	  if(first == FALSE) {
	    printf(", ");
	  }
	  first = FALSE;

	  t = GetMonSetItem(p1, k);
	  print_prev(r, "gp", t, i);
	  if(i == 1) {
	    AddtoMonSet(gpset, t);
	  }

	}

	if(size > 1) {
	  printf("}");
	}
	  
      }
      
      if((transitions[j]->preset->nextplace != NULL)||
	 ((semantics == 2) && ((optimize_level == 0) || (r != FALSE) || (i > 1)))) {
	printf("}");
      }
      printf("};\n");
	
      assign_begin(r);
      print_prev(r, "tt", j, i);
      assign_end(r);
      
    }


    // Output interleave forcing circuit

    if(semantics == 0) {

      size = GetMonSetSize(t_prev);
      if(size > 1) {

	print_prev_nonum(r, "non_concurrent", i);
	printf(" := [0,1] {");
	first = TRUE;
    
	for(j = 0; j < numtransitions; j++) {

	  if(!InMonSet(t_prev, j)) {
	    continue;
	  }

	  if(first == FALSE) {
	    printf(", ");
	  }
	  first = FALSE;

	  print_prev(r, "t", j, i);

	}

	printf("};\n");
	assign_begin(r);
	print_prev_nonum(r, "non_concurrent", i);
	assign_end(r);

      }

    }


    // Output idling removal circuit

    if(do_no_idle != FALSE) {

      print_prev_nonum(r, "non_idle", i);
      printf(" := ");

      size = GetMonSetSize(t_prev);
      if(size == 0) {
	printf("F;\n");
      } else {

	if(size > 1) {
	  printf("OR {");
	}

	first = TRUE;
    
	for(j = 0; j < numtransitions; j++) {

	  if(!InMonSet(t_prev, j)) {
	    continue;
	  }

	  if(first == FALSE) {
	    printf(", ");
	  }
	  first = FALSE;

	  print_prev(r, "t", j, i);

	}

	if(size > 1) {
	  printf("}");
	}
	printf(";\n");

      }

      assign_begin(r);
      print_prev_nonum(r, "non_idle", i);
      assign_end(r);

    }
    

    // Output the conflicts

    for(j = 0; j < numplaces; j++) {

      // Check that the place exists

      if(!InMonSet(p_prev, j)) {
	continue;
      }


      ClearMonSet(t1);
      for(ac = places[j]->postset;
	  ac != NULL;
	  ac = ac->nexttransition) {

	t = (ac->transition->id -1);
	if(!InMonSet(t_prev, t)) {
	  continue;
	}
	AddtoMonSet(t1, t);

      }    
      size = GetMonSetSize(t1);

      if(size < 2) {

	// Less than two transitions in the postset of this place
	continue;

      }

      if(size == 2) {

	// Special case the two transition case

	print_prev(r, "cp", j, i);
	printf(" := AND {");
	
	ASSERT(size == 2);
	for(k = 0, first = TRUE; k < size; k++) {

	  if(first == FALSE) {
	    printf(", ");
	  }
	  first = FALSE;

	  t = GetMonSetItem(t1, k);
	  print_prev(r, "t", t, i);
	
	}   

	printf("};\n");

	assign_begin(r);
	printf("~");
	print_prev(r, "cp", j, i);
	assign_end(r);

	continue;

      }

      // More than two transitions, do the general case

      ASSERT(size >= 2);
      
      print_prev(r, "ncp", j, i);
      printf(" := [0,1] {");
      
      for(k = 0, first = TRUE; k < size; k++) {

	if(first == FALSE) {
	  printf(", ");
	}
	first = FALSE;

	t = GetMonSetItem(t1, k);
	print_prev(r, "t", t, i);

      }      

      printf("};\n");

      assign_begin(r);
      print_prev(r, "ncp", j, i);
      assign_end(r);


    }


    // Generate the state change circuit

    for(j = 0; j < numplaces; j++) {

      // Skip if not needed on the next level

      if(!InMonSet(p_curr, j)) {
	continue;
      }


      // The generate var are defined next

      // Skip this one if not needed on the next round
      if(InMonSet(gp_curr, j)) {

	if(places[j]->preset == NULL) {
	  print_curr(r, "gp", j, i);
	  printf(" := F;\n");
	  size2 = 0;
	  
	} else {

	  ClearMonSet(t1);
	  for(ac = places[j]->preset;
	      ac != NULL;
	      ac = ac->nexttransition) {

	    t = (ac->transition->id -1);

	    if(!InMonSet(t_prev, t)) {
	      continue;
	    }

	    AddtoMonSet(t1, t);

	  }
	  size2 = GetMonSetSize(t1);
	  ASSERT(size2 != 0);


	  if((size2 > 1) || (optimize_level == 0) || (r != FALSE)) {

	    print_curr(r, "gp", j, i);
	    printf(" := ");

	    if(size2 > 1) {
	      printf("OR {"); // More than one transition in the postset
	    }

	  }

	  for(k = 0, first = TRUE; k < size2; k++) {

	    t = GetMonSetItem(t1, k);

	    if((size2 > 1) || (optimize_level == 0) || (r != FALSE)) {

	      if(first == FALSE) {
		printf(", ");
	      }
	      first = FALSE;
	
	      print_prev(r, "t", t, i);

	    }
	  
	  }

	  // Remember the last generating transition (matter when size2 = 1)
	  gentran = t;
	  
	  if((size2 > 1) || (optimize_level == 0) || (r != FALSE)) {

	    if(size2 > 1) {
	      printf("}");
	    }

	    printf(";\n");

	  }
	
	}

      }

      // Skip the frame if not preset on the previous level

      if(InMonSet(p_prev, j)) {

	ClearSet(tset);

	for(ac = places[j]->postset;
	    ac != NULL;
	    ac = ac->nexttransition) {

	  t = (ac->transition->id -1);
	  if(!InMonSet(t_prev, t)) {
	    continue;
	  }

	  AddtoSet(tset, t);

	}

#ifndef NEVER_BOTH_GENERATE_AND_FRAME
      
	for(ac = places[j]->preset;
	    ac != NULL;
	    ac = ac->nexttransition) {

	  t = (ac->transition->id -1);
	  if(!InMonSet(t_prev, t)) {
	    continue;
	  }
	  RemovefromSet(tset, t);

	}

#endif /* NEVER_BOTH_GENERATE_AND_FRAME */
     

	size = GetSetSize(tset);

	if((size > 0) || (optimize_level == 0) || (r != FALSE)) {

	  print_curr(r, "fp", j, i);
	  printf(" := ");

	  if(size > 0) {
	    printf("AND {");
	  }
	  print_prev(r, "p", j, i);
	  if(size > 0) {
	    printf(", ~");
	    if(size > 1) {
	      printf("OR {");
	    }
	
	    for(k = 0, first = TRUE; k < size; k++) {

	      if(first == FALSE) {
		printf(", ");
	      }
	      first = FALSE;

	      print_prev(r, "t", (GetSetItem(tset, k)), i);

	    }
	
	    if(size > 1) {
	      printf("}");
	    }
	    printf("}");
  
	  }

	  printf(";\n");
    
	}

      }

      print_curr(r, "p", j, i);
      printf(" := ");
      if((InMonSet(gp_curr, j)) && (InMonSet(p_prev, j))) {
	printf("OR {");
      }

      if(InMonSet(gp_curr, j)) {
	if((size2 > 1) || (optimize_level == 0) || (r != FALSE)) {
	  print_curr(r, "gp", j, i);
	} else {
	  print_prev(r, "t", gentran, i);
	}
      }

      if((InMonSet(gp_curr, j)) && (InMonSet(p_prev, j))) {
	printf(", ");
      }

      if(InMonSet(p_prev, j)) {
	if((size > 0) || (optimize_level == 0) || (r != FALSE)) {
	  print_curr(r, "fp", j, i);
	} else {
	  print_prev(r, "p", j, i);
	}
      }

      if((InMonSet(gp_curr, j)) && (InMonSet(p_prev, j))) {
	printf("}");
      }

      printf(";\n");


      // The following is not required for completeness, however it does
      // supply an additional constraint which can be used by the solver!
      
#ifdef NEVER_BOTH_GENERATE_AND_FRAME

      if((InMonSet(gp_curr, j)) && (InMonSet(p_prev, j))) {

	print_curr(r, "gfp", j, i);
	printf(" := AND {");      

	if((size2 > 1) || (optimize_level == 0) || (r != FALSE)) {
	  print_curr(r, "gp", j, i);
	} else {
	  print_prev(r, "t", gentran, i);
	}
	printf(", ");

	if((size > 0) || (optimize_level == 0) || (r != FALSE)) {
	  print_curr(r, "fp", j, i);
	} else {
	  print_prev(r, "p", j, i);
	}
	printf("};\n");

	assign_begin(r);
	printf("~");
	print_curr(r, "gfp", j, i);
	assign_end(r);

      }
      
#endif /* NEVER_BOTH_GENERATE_AND_FRAME */
      

    }

    DeleteMonSet(p_prev);
    DeleteMonSet(gp_prev);
    p_prev = p_curr;
    gp_prev = gp_curr;
    ClearMonSet(t_prev);
    p_curr = CreateMonSet(numplaces);
    ASSERT(p_curr != NULL);
    gp_curr = CreateMonSet(numplaces);
    ASSERT(gp_curr != NULL);
    
  }
    
  // Output the initial marking

  if(r != FALSE) {
    printf("\n//********************************************************\n");
    printf("INITIAL CONSTRAINT\n\n");
  }

  // The generate vars are forced to true on level 0 to remove unneeded models

  size = GetMonSetSize(gpset);
  if((size > 0) || (r != FALSE)) {

    // Do not assign gp vars which no not appear in bcsat input elsewhere
    
    assign_begin(r);
    for(j = 0, first = TRUE; j < numplaces; j++) {

      if(r == FALSE) {

	if(InMonSet(gpset, j) == FALSE) {
	  continue;
	}
      
      }
    
      if(first == FALSE) {
	printf(", ");
      }
      first = FALSE;

      print_prev(r, "gp", j, 1);
    
    }
    assign_end(r);

  }
  
  // Then the initial marking
  
  assign_begin(r);
  for(j = 0, first = TRUE; j < numplaces; j++) {

    ASSERT((places[j]->initial_marking == 0) ||
	   (places[j]->initial_marking == 1));

    if((places[j]->initial_marking == 0) && (optimize_level != 0) && (r == FALSE)) {
      continue;
    }

    if(first == FALSE) {
      printf(", ");
    }
    first = FALSE;
    
    if(places[j]->initial_marking == 0) {
      printf("~");
    }

    print_prev(r, "p", j, 1);
    
  }
  assign_end(r);


  if(r != FALSE) {
    printf("\n//********************************************************\n");
    printf("PROPERTY\n\n");
  }

  if((r == FALSE) && (do_deadlock != FALSE)) {

    i = bound;

    // Fix the places which have not yet appeared to false

    for(j = 0; j < numplaces; j++) {
      if(!InMonSet(p_prev, j)) {

	print_curr(r, "p", j, i);

	printf(" := F;\n");

      }

    }

    print_curr_nonum(r, "live", i);
    printf(" := OR {");
    
    for(j = 0; j < numtransitions; j++) {

      ASSERT(transitions[j]->preset != NULL);

      if(j != 0) {
	printf(", ");
      }
      
      if(transitions[j]->preset->nextplace != NULL) {
	printf("AND {");
      }
      
      for(ac = transitions[j]->preset, first = TRUE;
	  ac != NULL;
	  ac = ac->nextplace) {

	if(first == FALSE) {
	  printf(", ");
	}
	first = FALSE;

	print_curr(r, "p", (ac->place->id -1), i);
	
      }

      if(transitions[j]->preset->nextplace != NULL) {
	printf("}");
      }
      

    }
    printf("};\n");

    assign_begin(r);
    printf("~");
    print_curr_nonum(r, "live", i);
    assign_end(r);
    
  }

  DeleteMonSet(p1);
  DeleteMonSet(t1);

  DeleteMonSet(t_prev);

  DeleteMonSet(gp_curr);
  DeleteMonSet(gp_prev);
  DeleteMonSet(p_curr);
  DeleteMonSet(p_prev);

  DeleteMonSet(gpset);
  DeleteSet(tset);
  
}
