#include "set.h"
#include "alloc.h"
#include "dassert.h"
#include "ulhsort.h"

SET *CreateSet(unsigned long domainsize)
{
  SET *sset;
  ASSERT(domainsize != 0);

  sset = (SET *)xmalloc(sizeof(SET) +
			((domainsize -1) * sizeof(SET_ITEM)));
  sset->setbits = CreateBitArray(domainsize*2);
  sset->curr_item = &sset->set_items[0];
  sset->dirty_set = FALSE;

  return sset;

}

void ClearSet(SET *sset)
{
  SET_ITEM *curr_item;
  SET_ITEM *set_items;
  SET_ITEM item;
  BITARRAY *setbits;

  setbits = sset->setbits;
  curr_item = sset->curr_item;
  set_items = &sset->set_items[0];
  sset->curr_item = set_items;
  sset->dirty_set = FALSE;

  while(curr_item != set_items) {

    curr_item--;
    item = *curr_item;

    ClearBit(setbits, (2*item));
    ClearBit(setbits, ((2*item)+1));

  }

}

void DeleteSet(SET *sset)
{

  DeleteBitArray(sset->setbits);
  free(sset);

}



void SortSet(SET *sset)
{
  unsigned long size;

  size = GetSetSize(sset);
  if(size > 1) {
    ULHeapSort(&(sset)->set_items[0], size);
  }

}



/* For internal use only! */

unsigned long DirtyGetSetSize(SET *sset)
{
  SET_ITEM *curr_item;
  SET_ITEM *set_items;
  SET_ITEM *set_items2;
  SET_ITEM item;
  BITARRAY *setbits;
  unsigned long size;

  setbits = sset->setbits;
  curr_item = sset->curr_item;
  set_items = &sset->set_items[0];
  set_items2 = set_items;

  for(size = 0; set_items != curr_item; set_items++) {

    item = *set_items;

    if(GetBit(setbits, (2*item)) != FALSE) {

      // This item belongs to the set

      size++;

      if(set_items2 != set_items) {

	// Do a write only if change is needed

	*set_items2 = item;
      }

      set_items2++;

    } else {

      // This item has been removed from the set

      ClearBit(setbits, ((2*item)+1));

    }

  }

  sset->curr_item = set_items2;
  sset->dirty_set = FALSE;

  return size;

}


/* For internal use only! */

BOOL DirtyEmptySet(SET *sset)
{
  unsigned long size;
  BOOL empty;

  size = DirtyGetSetSize(sset);

  empty = ((size == 0) ? (TRUE) : (FALSE));

  return empty;
  
}
