#include <stdio.h>
#include <strings.h>
#include <ctype.h>
#include <string.h>
#include <strings.h>
#include "alloc.h"
#include "dassert.h"
#include "ptnet.h"


PTNet::PTNet()
{
  buf = (char *)xmalloc(BUFSIZE);
  cursor = (char *)NULL;

  maxplaces = 1;
  maxtransitions = 1;

  placesbyname = (Place **)xmalloc(sizeof(Place *));
  placesbyname[0] = (Place *)NULL;
  transitionsbyname = (Transition **)xmalloc(sizeof(Transition *));
  transitionsbyname[0] = (Transition *)NULL;

  numplaces = 0;
  numtransitions = 0;
  numarcs = 0;

  places = (Place **)NULL;
  transitions = (Transition **)NULL;

  alist = (Alist *)NULL;

}


PTNet::~PTNet()
{
  unsigned long i;

  Alist *al;
  Alist *tmp;

  free(buf);
  free(placesbyname);
  free(transitionsbyname); 

  for(tmp = alist; tmp != NULL;) {

    al = tmp;
    tmp = tmp->next;

    free(al->arc);
    free(al);

    numarcs--;

  }

  ASSERT(numarcs == 0);

  for(i = 0; i < numplaces; i++) {
    if(places[i]->name != NULL) {
      free(places[i]->name);
    }
    if(places[i]->meaning != NULL) {
      free(places[i]->meaning);
    }
    free(places[i]);
  }

  free(places);

  
  for(i = 0; i < numtransitions; i++) {
    if(transitions[i]->name != NULL) {
      free(transitions[i]->name);
    }
    if(transitions[i]->meaning != NULL) {
      free(transitions[i]->meaning);
    }
    free(transitions[i]);
  }

  free(transitions);
  
}



BOOL PTNet::ReadPEP(FILE *in)
{
  BOOL OK = TRUE;
  BOOL autonumber = TRUE;
  BOOL numspecified;
  BOOL gotcoords;
  BOOL PetriBox = FALSE;
  unsigned long mode = 0;
  unsigned long line = 0;
  int autocount = 0;
  int num;
  int x;
  int y;
  char *str;

  char *meaning;
  int marking;
  BOOL entry;
  BOOL exit;

  int tmp;
  char *tmpstr;

  while((mode != 8) &&
	OK &&
	ReadLine(in) != FALSE) {

    line++;

    if(mode >= 3) {
      RemoveComments();
    }

    if(strlen(buf) == 0) {
      continue;
    }
#if 0
    fprintf(stdout, "Mode: %lu, \"%s\"\n", mode, buf);
#endif
    SetCursor(buf); // Init the cursor to the beginning of line


    switch(mode) {

    case 0:
      if(GetKeyword("PEP")) {
	mode = 1;
      } else {
	OK = FALSE;
      }
      break;

    case 1:
      if(GetKeyword("PetriBox")) {
	PetriBox = TRUE;
      }
      if(GetKeyword("PetriBox") || GetKeyword("PTNet")) {
	mode = 2;
      } else {
	OK = FALSE;
      }
      break;

    case 2:
      if(GetKeyword("FORMAT_N")) {
	mode = 3;
      } else {
	OK = FALSE;
      }
      break;

    case 3:

      // I really should handle the other keywords here, but I'm too
      // lazy to implement them now, so this will do for now. 20/09/2000/kepa

      if(GetKeyword("PL")) {
	mode = 4;

	autonumber = TRUE;
	autocount = 0;

      }

      // Didn't find the places yet, keep scanning forward

      break;

    case 4:

      if(GetKeyword("TR")) {
	mode = 5;


	autonumber = TRUE;
	autocount = 0;

      } else {

	// The place handling comes here

	if(autonumber) {
	  autocount++;
	}

	numspecified = FALSE; // Is the place number specified
	gotcoords = FALSE; // Are the coordinates specified

	num = 0;
	str = (char *)NULL;
	x = 0;
	y = 0;

	meaning = (char *)NULL;
	marking = 0;
	entry = FALSE;
	exit = FALSE;


	if(!(isNumber() || isString())) {
	  OK = FALSE;
	  break;
	}


	if(isNumber()) {

	  x = getNumber(); // Place number or x-coordinate

	  if(cursor[0] == '@') {

	    // OK, we have only coordinates here

	    cursor++;

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    y = getNumber();
	    gotcoords = TRUE;


	  } else {

	    if(x < 0) {
	      OK = FALSE;
	      break;
	    }

	    num = x;
	    x = 0;
	    numspecified = TRUE;
	    autonumber = FALSE;

	  }

	}


	if(isString()) {

	  if(gotcoords) {
	    OK = FALSE;
	    break;
	  }

	  str = getString();

	}


	if((!gotcoords) && isNumber()) {

	  x = getNumber(); // Place number or x-coordinate

	  if(cursor[0] != '@') {
	    OK = FALSE;
	    break;
	  }

	  // OK, we have only coordinates here

	  cursor++;

	  if(!isNumber()) {
	    OK = FALSE;
	    break;
	  }

	  y = getNumber();
	  gotcoords = TRUE;

	}


	// Unlike the documentation states, the coordinates don't
	// seem to be necessary!

#if NO_GOT_COORDS_BAD
	if(!gotcoords) {
	  OK = FALSE;
	  break;
	}
#endif

	if(!numspecified) {

	  if(autonumber) {
	    num = autocount;
	    numspecified = TRUE;
	  } else {
	    OK = FALSE;
	    break;
	  }

	}


	while(OK &&
	      cursor[0] != '\0') {

	  // Process the optional place stuff


	  switch(cursor[0]) {

	  case 'b':
	    cursor++;

	    // Meaning string

	    if(!isString()) {
	      OK = FALSE;
	      break;
	    }

	    meaning = getString();

	    break;

	  case 'M':
	    cursor++;

	    // Initial marking

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    marking = getNumber();

	    if(marking < 0) {
	      OK = FALSE;
	      break;
	    }

	    break;

	  case 'e':
	    cursor++;

	    entry = TRUE;

	    break;

	  case 'x':
	    cursor++;

	    exit = TRUE;

	    break;

	  case 'n':
	  case 'a':
	  case 'N':
	  case 'A':
	    cursor++;

	    // Coordinates ignored

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    if(cursor[0] != '@') {
	      OK=FALSE;
	      break;
	    }

	    cursor++;

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    break;

	  case 'm':
	  case 'k':
	  case 'v':
	  case 's':
	  case 't':
	  case 'c':
	    cursor++;

	    // Current marking, capasity, invisible,
	    // sx, thickness, and color ignored

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    break;


	  case 'R':
	  case 'T':
	  case 'u':
	    cursor++;

	    // Reference string, TReference string,
	    // and blocks list ignored

	    if(!isString()) {
	      OK = FALSE;
	      break;
	    }

	    tmpstr = getString();
	    free(tmpstr);

	    break;

	  default:
	    cursor++;

	    if(isspace(cursor[-1])) {
	      break;
	    }

	    OK = FALSE;
	    break;

	  }

	}


	// Entry and exit places should only exist in Petriboxes
	// but never both at the same time

	if(((!PetriBox) && entry) ||
	   ((!PetriBox) && exit) ||
	   (entry && exit)) {
	  OK = FALSE;
	}

	// Drop out of thew outer loop also if not OK

	if(OK == FALSE) {
	  break;

	}

	
	if(entry) {
	  marking = 1; // Entry place have the initial marking 1
	}


	// Everything set, print the stuff

#if 0
	fprintf(stdout, "Place number %d, at coordinates %d@%d, initial marking %d",
		num, x, y, marking);
	if(str != NULL) {
	  fprintf(stdout, ", name:\"%s\"", str);
	}
	if(meaning != NULL) {
	  fprintf(stdout, ", meaning:\"%s\"", meaning);
	}
	fprintf(stdout, "\n");
#endif

	if(insertPlace(num, str, meaning, marking) == FALSE) {
	  fprintf(stderr, "Place number %d multiply defined!\n", num);
	  OK = FALSE;
	  break;
	}

      }

      break;

    case 5:

      if(GetKeyword("TP")) {
	mode = 6;
      } else {

	// The transition handling comes here

	if(autonumber) {
	  autocount++;
	}

	numspecified = FALSE; // Is the transition number specified
	gotcoords = FALSE; // Are the coordinates specified

	num = 0;
	str = (char *)NULL;
	x = 0;
	y = 0;

	meaning = (char *)NULL;
	marking = 0;
	entry = FALSE;
	exit = FALSE;


	if(!(isNumber() || isString())) {
	  OK = FALSE;
	  break;
	}


	if(isNumber()) {

	  x = getNumber(); // Transition number or x-coordinate

	  if(cursor[0] == '@') {

	    // OK, we have only coordinates here

	    cursor++;

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    y = getNumber();
	    gotcoords = TRUE;


	  } else {

	    if(x < 0) {
	      OK = FALSE;
	      break;
	    }

	    num = x;
	    x = 0;
	    numspecified = TRUE;
	    autonumber = FALSE;

	  }

	}


	if(isString()) {

	  if(gotcoords) {
	    OK = FALSE;
	    break;
	  }

	  str = getString();

	}


	if((!gotcoords) && isNumber()) {

	  x = getNumber(); // Transition number or x-coordinate

	  if(cursor[0] != '@') {
	    OK = FALSE;
	    break;
	  }

	  // OK, we have only coordinates here

	  cursor++;

	  if(!isNumber()) {
	    OK = FALSE;
	    break;
	  }

	  y = getNumber();
	  gotcoords = TRUE;

	}


	// Unlike the documentation states, the coordinates don't
	// seem to be necessary!

#if NO_GOT_COORDS_BAD
	if(!gotcoords) {
	  OK = FALSE;
	  break;
	}
#endif

	if(!numspecified) {

	  if(autonumber) {
	    num = autocount;
	    numspecified = TRUE;
	  } else {
	    OK = FALSE;
	    break;
	  }

	}


	while(OK &&
	      cursor[0] != '\0') {

	  // Process the optional transition stuff

	  
	  switch(cursor[0]) {

	  case 'b':
	    cursor++;

	    // Meaning string

	    if(!isString()) {
	      OK = FALSE;
	      break;
	    }

	    meaning = getString();

	    break;

	  case 'n':
	  case 'a':
	  case 'N':
	  case 'A':
	    cursor++;

	    // Coordinates ignored

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    if(cursor[0] != '@') {
	      OK=FALSE;
	      break;
	    }

	    cursor++;

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    break;

	  case 'v':
	  case 's':
	  case 't':
	  case 'c':
	    cursor++;

	    // Invisible, sx, thickness, and color ignored

	    if(!isNumber()) {
	      OK = FALSE;
	      break;
	    }

	    tmp = getNumber();

	    break;


	  case 'R':
	  case 'T':
	  case 'u':
	    cursor++;

	    // Reference string, TReference string,
	    // and blocks list ignored

	    if(!isString()) {
	      OK = FALSE;
	      break;
	    }

	    tmpstr = getString();
	    free(tmpstr);

	    break;

	  case 'P':
	  case 'S':
	    cursor++;

	    // Synchronization ignored and phantom transitions
	    // not correctly handled, so give an error isntead of
	    // silently ignoring them

	    OK = FALSE;
	    break;

	  default:
	    cursor++;

	    if(isspace(cursor[-1])) {
	      break;
	    }

	    OK = FALSE;
	    break;

	  }

	}


	// Drop out of thew outer loop also if not OK

	if(OK == FALSE) {
	  break;

	}

	
	// Everything set, print the stuff

#if 0
	fprintf(stdout, "Transition number %d, at coordinates %d@%d",
		num, x, y);
	if(str != NULL) {
	  fprintf(stdout, ", name:\"%s\"", str);
	}
	if(meaning != NULL) {
	  fprintf(stdout, ", meaning:\"%s\"", meaning);
	}
	fprintf(stdout, "\n");
#endif

	if(insertTransition(num, str, meaning) == FALSE) {
	  fprintf(stderr, "Transition number %d multiply defined!\n", num);
	  OK = FALSE;
	  break;
	}

      }

      break;

    case 6:

      if(GetKeyword("PT")) {
	mode = 7;
      } else {

	// The transition -> place arc handling comes here

	if(isNumber()) {

	  x = getNumber();

	  if(cursor[0] != '<') {
	    OK = FALSE;
	    break;
	  }

	  cursor++;

	  if(isNumber()) {
	  
	    y = getNumber();
	  
	    if((x < 0) ||
	       (y < 0)) {
	      OK = FALSE;
	      break;
	    }

	    // TODO: Check that the rest of the line is OK!
#if 0
	    fprintf(stdout, "Arc from transition %d to place %d\n",
		    x, y);
#endif
	    if(insertTPArc(x, y) == FALSE) {
	      fprintf(stderr, "Arc from transition %d to place %d could not be added!\n",
		      x, y);
	      OK = FALSE;
	      break;
	    }

	  } else {
	    OK = FALSE;
	    break;
	  }


	} else {
	  OK = FALSE;
	  break;
	}
	
      }

      break;

    case 7:

      if(GetKeyword("PTP") || GetKeyword("PPT") || GetKeyword("TX")) {
	mode = 8;
      } else {

	// The place -> transition arc handling comes here

	if(isNumber()) {

	  x = getNumber();

	  if(cursor[0] != '>') {
	    OK = FALSE;
	    break;
	  }

	  cursor++;

	  if(isNumber()) {
	  
	    y = getNumber();
	  
	    if((x < 0) ||
	       (y < 0)) {
	      OK = FALSE;
	      break;
	    }


	    // TODO: Check that the rest of the line is OK!
#if 0
	    fprintf(stdout, "Arc from place %d to transition %d\n",
		    x, y);
#endif
	    if(insertPTArc(x, y) == FALSE) {
	      fprintf(stderr, "Arc from place %d to transition %d could not be added!\n",
		      x, y);
	      OK = FALSE;
	      break;
	    }


	  } else {
	    OK = FALSE;
	    break;
	  }


	} else {
	  OK = FALSE;
	  break;
	}
	
      }

      break;

    }


  }


  if((mode < 7) ||
     (OK == FALSE) ||
     (ferror(in))) {

    fprintf(stderr, "Error encountered on line %lu\n", line);
    return FALSE;

  }

  initPTNet();

  return TRUE;

}



BOOL PTNet::ReadLine(FILE *in)
{
  size_t len;

  if(fgets(buf, BUFSIZE, in) == NULL) {
    return FALSE;
  }

  if(ferror(in)) {
    return FALSE;
  }

  len = strlen(buf);

  if(len > 0) {

    if(buf[len-1] == '\n') {

      buf[len-1] = '\0';

    }

  }

  return TRUE;

}


BOOL PTNet::GetKeyword(const char *keyword)
{
  size_t len = strlen(keyword);

  if(!strncmp(buf, keyword, len)) {
    return TRUE;
  }

  return FALSE;


}


void PTNet::RemoveComments(void)
{
  unsigned long i;
  unsigned long size;
  BOOL instring;
  char *p;

  size = strlen(buf);

  p = NULL;
  instring = FALSE;
  for(i = 0; i < size; i++) {

    if(buf[i] == '"') {

      if(instring == FALSE) {
	instring = TRUE;
      } else {
	instring = FALSE;
      }

      continue;

    }
     
    if(instring == FALSE) {
      if(buf[i] == '\%') {

	p = &buf[i];
	break;

      }

    }

  }

  if(p != NULL) {

    *p = '\0';

  }

  return;

}


BOOL
PTNet::isNumber(void)
{
  int tmp = 0;

  ASSERT(cursor != NULL);

  if(sscanf(cursor, "%d", &tmp) == 1) { 

    return TRUE;

  }

  return FALSE;

}

int
PTNet::getNumber(void)
{
  int tmp = 0;

  ASSERT(cursor != NULL);

  if(sscanf(cursor, "%d", &tmp) == 1) { 

    while(isspace(*cursor)) {
      cursor++;
    }

    if(cursor[0] == '-'){
      cursor++;
    }

    while(isdigit(*cursor)) {
      cursor++;
    }

    return tmp;

  }

  ASSERT(FALSE);

  return 0;

}


BOOL
PTNet::isString(void)
{

  ASSERT(cursor != NULL);


  if((cursor[0] == '\"') &&
     (strchr(&cursor[1], '\"') != NULL)) {

    return TRUE;

  }

  return FALSE;

}


char *
PTNet::getString(void)
{
  char *tmp;
  char *tmp2;

  ASSERT(cursor != NULL);
  ASSERT(cursor[0] == '\"');

  tmp = strchr(&cursor[1], '\"');

  ASSERT(tmp != NULL);

  *tmp = '\0';

  tmp2 = strdup(&cursor[1]);

  *tmp = '\"';

  ASSERT(tmp2 != NULL);

  cursor = &tmp[1];
  
  return tmp2;

}



BOOL PTNet::insertPlace(unsigned long numname,
			char *name,
			char *meaning,
			unsigned long initial_marking)
{
  unsigned long newplaces;
  unsigned long i;
  Place *pl;

  if(numname >= maxplaces) {

    for(newplaces = maxplaces; numname >= newplaces; newplaces += newplaces) {
      ;
    }

    placesbyname = (Place **)xrealloc(placesbyname, (newplaces * sizeof(Place *)));

    for(i = maxplaces; i < newplaces; i++) {
      placesbyname[i] = (Place *)NULL;
    }

    maxplaces = newplaces;
    
  }

  if(placesbyname[numname] != NULL) {

    return FALSE;

  }

  pl = (Place *)xmalloc(sizeof(Place));

  pl->preset = NULL;       // These fields initialized later
  pl->postset = NULL;
  pl->id = 0;

  pl->name = name;
  pl->meaning = meaning;
  pl->initial_marking = initial_marking;

  placesbyname[numname] = pl;

  return TRUE;

}



BOOL PTNet::insertTransition(unsigned long numname,
			     char *name,
			     char *meaning)
{

  unsigned long newtransitions;
  unsigned long i;
  Transition *tr;

  if(numname >= maxtransitions) {

    for(newtransitions = maxtransitions; numname >= newtransitions; newtransitions += newtransitions) {
      ;
    }

    transitionsbyname = (Transition **)xrealloc(transitionsbyname,
						(newtransitions * sizeof(Transition *)));

    for(i = maxtransitions; i < newtransitions; i++) {
      transitionsbyname[i] = (Transition *)NULL;
    }

    maxtransitions = newtransitions;
    
  }

  if(transitionsbyname[numname] != NULL) {

    return FALSE;

  }

  tr = (Transition *)xmalloc(sizeof(Transition));

  tr->preset = NULL;       // These fields initialized later
  tr->postset = NULL;
  tr->id = 0;

  tr->name = name;
  tr->meaning = meaning;

  transitionsbyname[numname] = tr;

  return TRUE;

}



BOOL PTNet::insertTPArc(unsigned long transitionname,
			unsigned long placename)
{
  Arc *ac;
  Alist *al; // For easy deallocation

  if((transitionsbyname[transitionname] == NULL) ||
     (placesbyname[placename] == NULL)) {

    return FALSE; // Either end of the arc doesn't exist

  }

  ac = (Arc *)xmalloc(sizeof(Arc));

  ac->place = placesbyname[placename];
  ac->transition = transitionsbyname[transitionname];

  // Transition postset extension

  ac->nextplace = ac->transition->postset;
  ac->transition->postset = ac;

  // Place preset extension

  ac->nexttransition = ac->place->preset;
  ac->place->preset = ac;


  al = (Alist *)xmalloc(sizeof(Alist));

  al->arc = ac;
  al->next = alist;
  alist = al;

  numarcs++;

  return TRUE;

}


BOOL PTNet::insertPTArc(unsigned long placename,
			unsigned long transitionname)
{

  Arc *ac;
  Alist *al; // For easy deallocation

  if((transitionsbyname[transitionname] == NULL) ||
     (placesbyname[placename] == NULL)) {

    return FALSE; // Either end of the arc doesn't exist

  }

  ac = (Arc *)xmalloc(sizeof(Arc));

  ac->place = placesbyname[placename];
  ac->transition = transitionsbyname[transitionname];

  // Transition preset extension

  ac->nextplace = ac->transition->preset;
  ac->transition->preset = ac;

  // Place postset extension

  ac->nexttransition = ac->place->postset;
  ac->place->postset = ac;


  al = (Alist *)xmalloc(sizeof(Alist));

  al->arc = ac;
  al->next = alist;
  alist = al;

  numarcs++;

  return TRUE;

}


void PTNet::initPTNet(void)
{
  unsigned long i;

  for(i = 0; i < maxplaces; i++) {

    if(placesbyname[i] != NULL) {
      numplaces++;
    }

  }

  places = (Place **)xmalloc(numplaces * sizeof(Place *));
  numplaces = 0;

  for(i = 0; i < maxplaces; i++) {

    if(placesbyname[i] != NULL) {

      places[numplaces] = placesbyname[i];
      numplaces++;
      places[numplaces -1]->id = numplaces;
    }

  }


  for(i = 0; i < maxtransitions; i++) {

    if(transitionsbyname[i] != NULL) {
      numtransitions++;
    }

  }

  transitions = (Transition **)xmalloc(numtransitions * sizeof(Transition *));
  numtransitions = 0;

  for(i = 0; i < maxtransitions; i++) {

    if(transitionsbyname[i] != NULL) {

      transitions[numtransitions] = transitionsbyname[i];
      numtransitions++;
      transitions[numtransitions -1]->id = numtransitions;
    }

  }

#if 0
  fprintf(stdout, "Places: %lu, transitions: %lu\n",
	  numplaces, numtransitions);
#endif

}


unsigned long
PTNet::getPlId(char *name)
{
  unsigned long i;

  for(i=0; i < numplaces; i++) {

    if(!strcmp(name, places[i]->name)) {
      return (places[i]->id);
    }

  }

  return 0;

}
