/*
 * Main routines:
 *
 * Copyright 2001 Keijo Heljanko <Keijo.Heljanko@hut.fi>
 *
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "combi.h"
#include "main.h"
#include "dassert.h"
#include "ptnet.h"
#include "unroll.h"

#if 0
#include "scanner.h"
#include "tree.h"
#include "tree2smo.h"
#endif

static void usage(char *myname)
{
    fprintf(stderr,"============================================================================\n");
    fprintf(stderr,"Process unroller for 1-safe nets (Outputs boolean circuits)\n");
    fprintf(stderr,"Usage: %s [OPTION]... file1 [file2]\n",myname);
    fprintf(stderr,"\n");
    fprintf(stderr,"Options:\n");
    fprintf(stderr,"        -R       : Give transition relation and initial predicate (default)\n");
    fprintf(stderr,"        -b=num   : The number of time steps to unroll\n");
#if 0
    fprintf(stderr,"        -f=fname : Model check the LTL formula in the file fname\n");
#endif
    fprintf(stderr,"        -D       : Deadlock check the net\n");
    fprintf(stderr,"        -p       : Use process semantics (default)\n");
    fprintf(stderr,"        -s       : Use step semantics\n");
    fprintf(stderr,"        -i       : Use interleaved semantics\n");
    fprintf(stderr,"        -n       : Do not allow empty timesteps (default)\n");
    fprintf(stderr,"        -e       : Allow empty timesteps \n");
    fprintf(stderr,"        -O0      : Do not optimize the translation\n");
    fprintf(stderr,"        -O1      : Do optimizations (default)\n");
#if 0
    fprintf(stderr,"        -v       : Give verbose statistics\n");
#endif
    fprintf(stderr,"\n");
    fprintf(stderr,"        file1 : input file containing unfolding\n");
    fprintf(stderr,"                extension '.ll_net': PEP low level net\n");
    fprintf(stderr,"        file2 : output result file\n");
    fprintf(stderr,"\n");
    fprintf(stderr,"Copyright 2001 Keijo Heljanko <Keijo.Heljanko@hut.fi>\n");
    fprintf(stderr,"\n");
    fprintf(stderr,"Version 0.3, (%s)\n", __DATE__);
    fprintf(stderr,"============================================================================\n");

}

#if 0
// Some global variables, used in scanner.cc only!

FILE * yyin_for_parser;
PTNet * net_for_parser;
#endif

int main (int argc, char *argv[])
{

  FILE * in;
  FILE * in_formula;
  char * input_file;
  char * formula_file;
  char * output_file;
#if 0
  TreeNode * formula;
#endif
  BOOL verbose;
  BOOL error;
  BOOL step;
  BOOL interleaved;
  BOOL process;
  BOOL do_relation;
  BOOL do_bound;
  BOOL do_deadlock;
  BOOL do_formula;
  BOOL do_no_idle;
  BOOL arg_deadlock;
  BOOL arg_formula;
  BOOL arg_idle;
  unsigned long bound;
  unsigned long optimize_level;
  unsigned long semantics; // 0 = interleaved, 1 = step, 2 = process

  PTNet *net;

  // Give various defaults for parameters

  verbose = FALSE;
  step = FALSE;
  interleaved = FALSE;
  process = FALSE;
  do_deadlock = FALSE;
  do_formula = FALSE;
  do_relation = FALSE;
  do_bound = FALSE;
  do_no_idle = TRUE;
  
  arg_deadlock = FALSE;
  arg_formula = FALSE;
  arg_idle = FALSE;
  
  // Some defaults
  
  bound = 0;
  optimize_level = 1;
  semantics = 2;

  error = FALSE;

  in = (FILE *)NULL;
  in_formula = (FILE *) NULL;
  input_file = (char *)NULL;
  formula_file = (char *) NULL;
  output_file = (char *)NULL;

  net = (PTNet *)NULL;

  for (int c = 1; c < argc && error == FALSE; c++) {
    if (argv[c][0] == '-') {
      if (strcmp (&argv[c][1], "R") == 0) {
	do_relation = TRUE;
      }
      else if (strncmp (&argv[c][1], "b=", 2) == 0) {
	bound = atol(&argv[c][3]);
	do_bound = TRUE;
      }
      else if (strncmp (&argv[c][1], "f=", 2) == 0) {
        do_formula = TRUE;
        do_deadlock = FALSE;
        arg_formula = TRUE;
        formula_file = &argv[c][3];
      }
      else if (strcmp (&argv[c][1], "D") == 0) {
        do_deadlock = TRUE;
        do_formula = FALSE;
        arg_deadlock = TRUE;
      }
      else if (strcmp (&argv[c][1], "v") == 0) {
	verbose = TRUE;
      }
      else if (strcmp (&argv[c][1], "s") == 0) {
	step = TRUE;
      }
      else if (strcmp (&argv[c][1], "i") == 0) {
	interleaved = TRUE;
      }
      else if (strcmp (&argv[c][1], "p") == 0) {
	process = TRUE;
      }
      else if (strcmp (&argv[c][1], "n") == 0) {
	do_no_idle = TRUE;
	if(arg_idle != FALSE) {
	  error = TRUE;
	}
	arg_idle = TRUE;
      }
      else if (strcmp (&argv[c][1], "e") == 0) {
	do_no_idle = FALSE;
	if(arg_idle != FALSE) {
	  error = TRUE;
	}
	arg_idle = TRUE;
      }
      else if (strcmp (&argv[c][1], "O0") == 0) {
        optimize_level = 0;
      }
      else if (strcmp (&argv[c][1], "O1") == 0) {
        optimize_level = 1;
      }
      else {
	error = TRUE;
      }
    } else {
      if(input_file == NULL) {
	input_file = argv[c];
      } else if(output_file == NULL) {
	output_file = argv[c];
      } else {
	error = TRUE;
	break;
      }
    }
  }

  if(input_file == NULL) {
    error = TRUE;
  }

  if(((interleaved != FALSE) && (step != FALSE)) ||
     ((interleaved != FALSE) && (process != FALSE)) ||
     ((step != FALSE) && (process != FALSE))) {
    fprintf(stderr, "%s: Use only one of the semantics\n", argv[0]);
    exit(1);
  }

  if(interleaved != FALSE) {
    semantics = 0; // Use interleaved semantics
  } else if (step != FALSE) {
    semantics = 1; // Use step semantics
  } else if (process != FALSE) {
    semantics = 2; // Use process semantics
  } else {
    semantics = 2; // Use process semantics by default
  }

  // Only do deadlock or formula, but not both
  
  if(arg_formula != FALSE && arg_deadlock != FALSE) {
    fprintf(stderr, "%s: Both deadlock and model checking requested\n", argv[0]);
    error = TRUE;
  }
  if(do_formula != FALSE && formula_file == NULL) {
    fprintf(stderr, "%s: Error with the formula file\n", argv[0]);
    error = TRUE;
  }

  if((do_relation != FALSE) && (do_bound != FALSE)) {
    fprintf(stderr, "%s: Either relation or unrolling can be produced, not both\n", argv[0]);
    error = TRUE;
  }
  if((do_relation == FALSE) && (do_bound == FALSE)) {
    // Relation is the default
    do_relation = TRUE;
  }

  
  if(error != FALSE) {
    usage(argv[0]);
    exit(1);
  }
    
  if((in = fopen(input_file, "rb")) == NULL) {

    fprintf(stderr, "%s: No such PEP low level net file: %s\n", argv[0], input_file);
    exit(1);
   
  }

  if(output_file != NULL) {

    if(freopen(output_file, "wb", stdout) == NULL) {

      fprintf(stderr, "%s: Could not open output file: %s \n", argv[0], output_file);
      exit(1);
   
    }
    
  }

  if(formula_file != NULL) {

    if((in_formula = fopen(formula_file, "rb")) == NULL) {

      fprintf(stderr, "%s: No such formula file: %s\n", argv[0], formula_file);
      exit(1);
   
    }

  }



  net = new PTNet();

  if(net->ReadPEP(in) == FALSE) {

    fprintf(stderr, "%s: Error while parsing PEP low level net file: %s\n", argv[0], input_file);

    delete(net);
    exit(1);

  }

#if 0
  formula = (TreeNode *)NULL;
#endif
  
  if(do_formula != FALSE) {

    ASSERT(FALSE); // Not implemented yet!

    // TODO: Implement me!

#if 0

    // Pass two arguments through global variables for convenience.

    yyin_for_parser = in_formula;
    net_for_parser = net;

    formula = ParseFormula();

    fclose(in_formula);

    if(formula != NULL) {

     // Do formula processing
 
#define DEBUG_PRINT_FORMULA 0

#if DEBUG_PRINT_FORMULA
     TreeDisplay(stdout, formula);
     fprintf(stdout, "\n");
#endif

     if(IsSimpleReachabilityFormula(formula) == FALSE) {

       fprintf(stderr, "Formula is not simple reachability, aborting!\n");
       exit(1);

     }

     TreeOptimize(formula);

#if DEBUG_PRINT_FORMULA
     TreeDisplay(stdout, formula);
     fprintf(stdout, "\n");
#endif

      EvaluatePlacesInInitialState(formula);

#if DEBUG_PRINT_FORMULA
      TreeDisplay(stdout, formula);
      fprintf(stdout, "\n");
#endif

      TreeOptimize(formula);

#if DEBUG_PRINT_FORMULA
      TreeDisplay(stdout, formula);
      fprintf(stdout, "\n");
#endif

#undef DEBUG_PRINT_FORMULA


    } else {

      exit(1); // Parse error in formula

    }

#endif /* 0 */

  }

  unroll(net, bound, semantics, optimize_level,
	 do_deadlock, do_formula, do_relation, do_no_idle);
#if 0
    , formula);
#endif

  delete(net);

  fflush(stdout);

#if 0
  if(debugging == FALSE) {

    fflush(stdout);

  }
#endif

  if(output_file != NULL) {
    fclose(stdout);
  }
  
  fclose(in);
  
  return 0;

}


