// Copyright 2004,2006 Jouni K. Seppnen          -*- coding: iso-8859-1 -*-
// Distributed under the Boost Software License, Version 1.0.
// See accompanying file LICENSE.

#pragma implementation "search.h"
#include "search.h"

#include "tile.h"
#include "model.h"

#include <algorithm>
#include <cstdlib>
#include <vector>
#include <iostream>

namespace Tilings {
  Tile Search::random_tile() const
  {
    Tile result(0,0,0,0);
    bool found = false;
    while (!found) {
      long int 
	top = random() % data.dim1(),
	bottom = random() % data.dim1(),
	left = random() % data.dim2(),
	right = random() % data.dim2();
      if (top > bottom)
	std::swap(top,bottom);
      if (left > right)
	std::swap(left,right);
      
      result = Tile(top,bottom,left,right);
      result.check_bounds();
      found = true;
      //std::cout << result << std::endl;
      std::vector<Tile*> avoid = model.all_tiles();
      assert(avoid.size() >= 1);
      std::vector<Tile*>::const_iterator i;
      for(i = avoid.begin(); i != avoid.end(); i++) {
	if (result.partially_overlaps(**i)) {
	  //std::cout << "Bad due to " << **i << std::endl;
	  found = false;
	  break;
	}
      }
      if (bad(result, avoid))
	found = false;
    }
    return result;
  }


  std::pair<Tile,double> GreedySearch::restart()
  {
    using namespace std;

    // init with random tile
    Tile current = random_tile();
    double curr_utility = model.llh_increase(current);
    // hill-climbing search
    while(1) {
      vector<Tile> neighbors = current.neighbors(0,model.all_tiles());
      vector<Tile>::iterator i;
      vector<double> utilities;
      vector<double>::iterator best;
      cout << "Current tile: " << current
	   << ' ' << curr_utility << endl;
      filter_neighbors(neighbors, model.all_tiles());
#if 0
      cout << "Neighbors: ";
      for (unsigned int n = 0; n < neighbors.size(); n++)
	cout << neighbors[n] << " ";
      cout << endl;
#endif
      if (neighbors.size() == 0) {
	cout << "Dead end: tile has no neighbors!" << endl;
	abort();
      }
      
      for (i = neighbors.begin(); i != neighbors.end(); i++)
	utilities.push_back(model.llh_increase(*i));
      best = max_element(utilities.begin(), utilities.end());
      if (*best <= curr_utility) // local maximum
	break;
      curr_utility = *best;
      current = neighbors[best-utilities.begin()];
    }
    return make_pair(current,curr_utility);
  }

  const Model& GreedySearch::run()
  {
    using namespace std;
    Tile best(0,0,0,0);
    double utility = -INFINITY;
    for (unsigned int r = 0; r < restarts; r++) {
      pair<Tile,double> pp = restart();
      cout << "Restart " << r << ": " << pp.first 
	   << " at llh increase " << pp.second << endl;
      if (pp.second > utility) {
	best = pp.first;
	utility = pp.second;
	cout << " -- new best tile!" << endl;
      }
    }
//     cerr << "Old llh: " << model.log_likelihood() << endl;
    model.add_tile(best);
//     cerr << "New llh: " << model.log_likelihood() << endl;
//     cerr << "Supposed increase: " << utility << endl;

    return model;
  }

  bool Search::bad
  (const Tile& candidate, const std::vector<Tile*>& avoid) const
  {
    for (std::vector<Tile*>::const_iterator
	   i = avoid.begin() + 1; // first one is whole data
	 i != avoid.end();
	 i++)
      if (bad(candidate,**i))
	return true;
    return false;
  }

  void Search::filter_neighbors
  (std::vector<Tile>& neighbors, const std::vector<Tile*>& avoid) const
  {
    typedef std::vector<Tile> tilevec;

    for (tilevec::iterator
	   i = neighbors.begin();
	 i != neighbors.end();
	 )
      {
	if (bad(*i, avoid))
	  i = neighbors.erase(i);
	else
	  i++;
      }
  }

}
