/* popsim: a simple population simulator
 * Copyright (C) 2004-2006  Jouni K. Seppänen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
*/

#ifndef RANDFUN_H
#define RANDFUN_H

#include <stdlib.h>

void randfun_set_seed(uint seed);
void randfun_set_type(const char *type);
void randfun_init(void);
void randfun_cleanup(void);
void randfun_write_config(void);

uint poisson(double mu);	/* random # from Poisson distribution */
unsigned short coinflip(void);	/* 0/1, 50%/50% */
void sample(uint arraysize, uint *array, 
	    uint howmany, uint *result);
uint randrange(uint n);

#endif

