/* popsim: a simple population simulator
 * Copyright (C) 2004-2006  Jouni K. Seppänen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
*/

#ifndef FAMTRACK_H
#define FAMTRACK_H

#include <stdlib.h>

struct famtrack {
  uint minfamily, maxfamily;
  uint nfamilies, *fsizes;
};

struct famtrack *ft_init(uint n, uint *familyvec);
void ft_delete(struct famtrack *ft);
void ft_decrease(struct famtrack *ft, uint fam);

/* NB -- Keep inline funs in sync with C file. */

inline extern uint 
ft_isempty(struct famtrack *ft, uint fam)
{
  return !(ft->fsizes[fam - ft->minfamily]);
}

inline extern void
ft_clear(struct famtrack *ft, uint fam)
{
  ft->fsizes[fam - ft->minfamily] = 0;
}


#endif
