// Copyright 2005,2006 Jouni K. Seppnen          -*- coding: iso-8859-1 -*-
// Distributed under the Boost Software License, Version 1.0.
// See accompanying file LICENSE.

// Computes the size of the intersection of two sorted sequences.

template <typename iter1, typename iter2>
  /* inline */ 
int
intersectionSize(iter1 begin1, iter1 end1, iter2 begin2, iter2 end2)
{
  int result = 0;
  while (begin1 != end1 && begin2 != end2) {
    if (*begin1 < *begin2)
      begin1++;
    else if (*begin1 > *begin2)
      begin2++;
    else {
      result++;
      begin1++;
      begin2++;
    }
  }
  return result;
}
