function [roc, auroc] = roc(good, bad)

% Matlab function roc.m to estimate the ROC curve
% and the corresponding area under the ROC curve.
% 
% (c) Jaakko Hollmen, Helsinki University of Technology
%     e-mail: Jaakko.Hollmen@hut.fi
%     May, 2004

% Number of samples per class excluding NaN's:
good_finite_ind = find(isfinite(good));
bad_finite_ind = find(isfinite(bad));
ngood = length(good_finite_ind);
nbad = length(bad_finite_ind);

if ngood == 0 || nbad == 0, 
  roc = NaN;
  auroc = NaN;
else

  good = good(good_finite_ind);
  bad = bad(bad_finite_ind);
  
  all_thresholds = sort([-inf; good; bad; inf]);
  [n_rows, n_cols] = size(all_thresholds);

  % Calculate the exact ROC based on all thresholds:
  roc = [];
  for i=1:n_rows,
    % this threshold:
    t = all_thresholds(i); 
    % false alarms and right alarms:
    roc = [roc; sum(good>=t)/ngood sum(bad>=t)/nbad t];
  end
  
  % Calculate the area under the ROC curve with
  % the trapezoid rule (gives an exact area):
  roc2 = flipud(roc);
  auroc = 0;
  for i=1:n_rows-1,
    % Trapezoid rule gives exact area:
    thisarea = (roc2(i+1,1) - roc2(i,1)) * mean([roc2(i,2) roc2(i+1,2)]);
    auroc = auroc + thisarea;
  end
end

% __END__
