function multi_rand_init = func_multiple_rand_init(data, dname)
%%% Clustering_by_co_init.: implementing random_init with 50 random seeds
%%% He Zhang, Feb. 2013

warning('off');

%% involved methods
methods = {...
    'KernelPNMFeu', ...
    'NonnegativeSpectralClustering', ...
    'SymTriOrthNMF', ...
    'lsd', ...
    'SymPLSA', ...
    'dcd_1', ...
    'dcd_1.2', ...
    'dcd_2', ...
    'dcd_5'
    };
nm = length(methods);% 9 methods
max_iter = 10000;
check_step = 10001;
verbose = false;

%% generate 50 random integers (seeds) in range [1, 1e9]
nSeed = 0; rand('seed', nSeed);
seeds = randi(1e9, [1 50]);
ns = length(seeds);

%% multiple random initialization
multi_rand_init = cell(1, 3); objs = zeros(ns, nm);
purities = zeros(ns, nm); nmis = zeros(ns, nm);

% load graph data
graph = sparse(data.A); graph = double(graph+graph'>0);
A = graph;  A(logical(eye(size(A, 1)))) = 0;
label = data.C; k = length(unique(label));

% random initialization for 50 times
multi_rand_init{1, 1} = dname;
sdindx = 0;
for sd = seeds
    sdindx = sdindx + 1;
    rand('seed', sd);
    W0 = rand(size(A, 1), k);
    for mi = 1:nm
        method = methods{mi}; alp = 0;
        %fprintf('\nNow random_init in : %s(size=%g)\n', method, size(A, 1));
        [W, obj] = func_meta_clustering(method, A, k, max_iter, check_step, verbose, nSeed, W0);
        [~, testLabel] = max(W, [], 2);
        purity = compute_purity_entropy(label, testLabel);
        nmi = compute_nmi(label, testLabel);
        % save random_init
        purities(sdindx, mi) = purity;
        nmis(sdindx, mi) = nmi;
        objs(sdindx, mi) = obj;
    end
end

% choose the best results with minimum objectives and save results
[~, indx] = min(objs);
for c = 1:nm
    multi_rand_init{1, 2} = [multi_rand_init{1, 2}, purities(indx(c), c)];
    multi_rand_init{1, 3} = [multi_rand_init{1, 3}, nmis(indx(c), c)];
end

