function [W, obj] = func_meta_clustering(method, A, k, max_iter, check_step, verbose, nSeed, W0)
% the utility function used for calling various NMF-based methods
% He Zhang, Sep. 2012

switch method
    case 'KernelPNMFeu'
        [W, obj] = KernelPNMFeu(A, k, max_iter, check_step, W0);
    case 'NonnegativeSpectralClustering'
        [W, obj] = NonnegativeSpectralClustering(A, k, max_iter, check_step, W0);
    case 'SymTriOrthNMF'
        [W, ~, obj]  = SymTriOrthNMF(A, k, max_iter, check_step, W0, []);
    case 'lsd'
        [W, obj] = lsd(A, k, max_iter, check_step, verbose, W0, nSeed);
    case 'SymPLSA'
        [W, ~,obj] = SymPLSA(sparse(A), k, max_iter, check_step, W0, []);
    case {'dcd_1', 'dcd_1.2', 'dcd_2', 'dcd_5'}
        alp = str2double(method((find(method=='_', 1, 'last')+1):end));
        [W, obj] = dcd(sparse(A), k, alp, max_iter, W0, nSeed);
end
