function results_km = func_kmeans_19datasets(data, dname)
%%% Clustering_by_co-init.: running k-means for the 19 datasets
%%% He Zhang, March 2013

warning('off');

%% k-means
results_km = cell(1, 3);

% data name
results_km{1, 1} = dname;

% load multivariate data
X = data.X; label = data.C; k = data.nc; clear data;

% running kmeans of Matlab
rand('seed', 0); randn('seed', 0);
km_label = kmeans(X, k, 'emptyaction', 'singleton');

% save results
purity= compute_purity_entropy(label, km_label);
nmi = compute_nmi(label, km_label);
results_km{1, 2} = purity;
results_km{1, 3} = nmi;

