function label = func_ensemble_comatrix(bases, k)
% cluster ensemble using co-association matrix, He Zhang, Oct. 2012
% see: A. Fred et al., "Combining multiple clusterings using
% evidence accumulation", Trans. of PAMI, 2005

[n, m] = size(bases);
S = zeros(n, n);

% create co-association matrix
for i = 1:m
    A = repmat(bases(:, i), 1, n);
    B = repmat(bases(:, i)', n, 1);
    S = S + (A==B);
    %S = S + (repmat(bases(:, i), 1, n)==repmat(bases(:, i)', n, 1));
end
S = S/m;

% final clustering using agglomerative methods: SL, CL, AL
label = clHC(S, k);