function bc = func_ensemble_bestclustering(bases)
% cluster ensemble using the BESTCLUSTERING algorithm, He Zhang, Dec. 2012
% see: A. Gionis et al., "Clustering Aggregation", ICDE, 2005

% implement BESTCLUSTERING algorithm
[n, m] = size(bases);
dis = zeros(1, m);
for i = 1:m
    S_cur = (repmat(bases(:, i), 1, n)==repmat(bases(:, i)', n, 1));
    for j = 1:m
        S_oth = (repmat(bases(:, j), 1, n)==repmat(bases(:, j)', n, 1));
        match = (S_cur~=S_oth);
        dis(i) = dis(i) + sum(sum(match));
    end
end

% return the base with min disagreement
[~, indx] = min(dis);
bc = bases(:, indx);
