function ncut_bases = func_compute_ncut_bases(data, dname)
%%% Clustering_by_co_init.: using ncut-init results as ensemble bases
%%% He Zhang, Mar. 2013

warning('off');

%% involved methods
methods = {...
    'OneSpectralClustering', ...
    'KernelPNMFeu', ...
    'NonnegativeSpectralClustering', ...
    'SymTriOrthNMF', ...
    'lsd', ...
    'SymPLSA', ...
    'dcd_1', ...
    'dcd_1.2', ...
    'dcd_2', ...
    'dcd_5'
    };
nm = length(methods);% 10 methods
max_iter = 1;
check_step = 10001;
verbose = false;
nSeed = 0;

%% computing ensemble bases using NCUT initialization
ncut_bases = cell(1, 12);
ncut_bases{1, 1} = dname;

% load graph data
graph = sparse(data.A); graph = double(graph+graph'>0);
A = graph;  A(logical(eye(size(A, 1)))) = 0;
label = data.C; k = length(unique(label));

% ncut-init for each method
W0 = ncutW(A, k);
[~, testLabel] = max(W0, [], 2);
ncut_bases{1, 2} = testLabel; % adding the NCUT base
W0 = W0+0.2;
W0 = bsxfun(@rdivide, W0, sum(W0,1));

% loop in the remaining 10 methods
for mi = 1:nm
    method = methods{mi};
    %fprintf('\nNow ncut_init in : %s(size=%g)\n', method, size(A, 1));
    if strcmp(method, 'OneSpectralClustering')
        W = OneSpectralClustering(A, 'rcc', k, 0, 0, 0);
        W = W(:, end);
        testLabel = W;
    else
        [W, obj] = func_meta_clustering(method, A, k, max_iter, check_step, verbose, nSeed, W0);
        [~, testLabel] = max(W, [], 2);
    end
    ncut_bases{1, 2+mi} = testLabel;
end

ncut_bases = cell2mat(ncut_bases(1, 2:end));
