function display_clustering_results_exp2(ds, results_bc, results_co, results_cts, results_meta_init)
%%% Clustering_by_co_initializations: check clustering results of the 2nd experiment
%%% He Zhang, Oct. 2013

%% load clustering results
bc = results_bc;
co = results_co;
linkclue = results_cts; 
heter_init = results_meta_init;

%% involved methods
methods = {...
    'BEST', ...
    'CO', ...
    'CTS', ...
    'DCD'
    };
nm = length(methods);

%% 19 datasets used in the manuscript
datasets = cell(1, 19);
datasets{1} = 'ORL';
datasets{2} = 'MED';
datasets{3} = 'VOWEL';
datasets{4} = 'COIL20';
datasets{5} = 'SEMEION';
datasets{6} = 'FAULTS';
datasets{7} = 'SEGMENT';
datasets{8} = 'CORA';
datasets{9} = 'CITESEER';
datasets{10} = '7SECTORS';
datasets{11} = 'OPTDIGITS';
datasets{12} = 'SVMGUIDE1';
datasets{13} = 'ZIP';
datasets{14} = 'USPS';
datasets{15} = 'PENDIGITS';
datasets{16} = 'PROTEIN';
datasets{17} = '20NEWS';
datasets{18} = 'LET-REC';
datasets{19} = 'MNIST';

%% print out clustering results
fprintf('\n***Clustering results of the 2nd experiment:\n\n');

% Purity
fprintf('Purity:\n');
fprintf('---------------------------\n');
p_bc = bc{1, 2};
p_co = co{1, 2}; % the Complete-Linkage method
p_linkclue = linkclue{1, 2};
p_dcd_heter5 = heter_init{1, 2}(end, 6); % the 5th round of DCD-co-init
fprintf('%4s: %3.2f\n', methods{1}, p_bc);
fprintf('%4s: %3.2f\n', methods{2}, p_co);
fprintf('%4s: %3.2f\n', methods{3}, p_linkclue);
fprintf('%4s: %3.2f\n', methods{4}, p_dcd_heter5);
fprintf('---------------------------\n\n');

% NMI
fprintf('NMI:\n');
fprintf('---------------------------\n');
n_bc = bc{1, 3};
n_co = co{1, 3}; % the Complete-Linkage method
n_linkclue = linkclue{1, 3};
n_dcd_heter5 = heter_init{1, 3}(end, 6); % the 5th round of DCD-co-init
fprintf('%4s: %3.2f\n', methods{1}, n_bc);
fprintf('%4s: %3.2f\n', methods{2}, n_co);
fprintf('%4s: %3.2f\n', methods{3}, n_linkclue);
fprintf('%4s: %3.2f\n', methods{4}, n_dcd_heter5);
fprintf('---------------------------\n\n');

