function display_clustering_results_exp1(ds, results_km, multi_rand_init, ncut, ncut_init, meta_init)
%%% Clustering_by_co_initialization: check clustering results of the 1st experiment
%%% He Zhang, Oct. 2013

%% load clustering results
km = results_km;
rand_init = multi_rand_init;
heter_init = meta_init;

%% involved methods
methods = {...
    'PNMF', ...
    'NSC', ...
    'ONMF', ...
    'LSD', ...
    'PLSI', ...
    'DCD1', ...
    'DCD1.2', ...
    'DCD2', ...
    'DCD5'
    };
nm = length(methods); % 9 main methods

%% 19 datasets used in the manuscript
datasets = cell(1, 19);
datasets{1} = 'ORL';
datasets{2} = 'MED';
datasets{3} = 'VOWEL';
datasets{4} = 'COIL20';
datasets{5} = 'SEMEION';
datasets{6} = 'FAULTS';
datasets{7} = 'SEGMENT';
datasets{8} = 'CORA';
datasets{9} = 'CITESEER';
datasets{10} = '7SECTORS';
datasets{11} = 'OPTDIGITS';
datasets{12} = 'SVMGUIDE1';
datasets{13} = 'ZIP';
datasets{14} = 'USPS';
datasets{15} = 'PENDIGITS';
datasets{16} = 'PROTEIN';
datasets{17} = '20NEWS';
datasets{18} = 'LET-REC';
datasets{19} = 'MNIST';

%% print out clustering results
fprintf('\n***Clustering results of the 1st experiment:\n\n');

% Purity
fprintf('Purity:\n');
fprintf('---------------------------\n');
p_all = [];
p_km = km{1, 2};
p_ncut = ncut{1, 2};
p_1spec = ncut_init{1, 2}(end);
p_rand_init = rand_init{1, 2}(1:9);
p_ncut_init = ncut_init{1, 2}(1:9);
p_heter_init1 = heter_init{1, 2}(1, 1:9);
p_heter_init5 = heter_init{1, 2}(end, 1:9);
p_all = [p_rand_init; p_ncut_init; p_heter_init1; p_heter_init5];
fprintf('    KM: %3.2f\n  NCUT: %3.2f\n1-SPEC: %3.2f\n', p_km, p_ncut, p_1spec);
fprintf('---------------------------\n');
for ms = 1:nm
    fprintf('%6s: %3.2f %3.2f %3.2f %3.2f\n', ...
        methods{ms}, p_all(1, ms), p_all(2, ms), p_all(3, ms), p_all(4, ms));
end
fprintf('---------------------------\n\n');

% NMI
fprintf('NMI:\n');
fprintf('---------------------------\n');
n_all = [];
n_km = km{1, 3};
n_ncut = ncut{1, 3};
n_1spec = ncut_init{1, 3}(end);
n_rand_init = rand_init{1, 3}(1:9);
n_ncut_init = ncut_init{1, 3}(1:9);
n_heter_init1 = heter_init{1, 3}(1, 1:9);
n_heter_init5 = heter_init{1, 3}(end, 1:9);
n_all = [n_rand_init; n_ncut_init; n_heter_init1; n_heter_init5];
fprintf('    KM: %3.2f\n  NCUT: %3.2f\n1-SPEC: %3.2f\n', n_km, n_ncut, n_1spec);
fprintf('---------------------------\n');
for ms = 1:nm
    fprintf('%6s: %3.2f %3.2f %3.2f %3.2f\n', ...
        methods{ms}, n_all(1, ms), n_all(2, ms), n_all(3, ms), n_all(4, ms));
end
fprintf('---------------------------\n\n');

