function [purity entropy]= compute_purity_entropy(Ground, Estimation)
% compute purity and entropy values for cluster analysis 
% Ground: the ground truth of clustering
% Estimation: estimated clustering results
% He Zhang, July 2011
% Ref: Z.Yang and E.Oja: Linear and non-linear projective 
% nonnegative matrix factorization, IEEE Transactions on Neural Networks 2010

Ground = Ground(:);
Estimation = Estimation(:);

cluster_set = unique(Estimation);
r = length(cluster_set);

true_cluster_set = unique(Ground);
q = length(true_cluster_set);

nkl = zeros(r,q);
for k = 1:r
   
    tmp = Ground(find(Estimation==cluster_set(k)));
    for l = 1:q
        nkl(k,l) = length(find(tmp==true_cluster_set(l)));
    end
end

purity = sum(max(nkl,[],2))/length(Estimation);

nk = sum(nkl,2);
% note: the length(unique(Ground)) must equal to length(unique(Estimation))
entropy = -sum(sum(nkl.*log2(eps+bsxfun(@rdivide, nkl, nk))))/(length(Estimation)*log2(q+eps));
