%%% Ncuts by Shi jian bo, tuned by He June, 2011

%function demoNcutImage;
% demoNcutImage
% 
% demo for NcutImage
% also initialize matlab paths to subfolders
% Timothee Cour, Stella Yu, Jianbo Shi, 2004.

disp('Ncut Image Segmentation demo');

%% read image, change color image to brightness image, resize to 160x160
%I = imread_ncut('jpg_images/1.jpg',100,100);
%I = imread_ncut('jpg_images/2.jpg',100,100);
%I = imread_ncut('jpg_images/3.jpg',100,100);
%I = imread_ncut('jpg_images/nature1.jpg',100,100);
%I = imread_ncut('jpg_images/00000186.jpg',100,100);
%I = imread_ncut('jpg_images/00000018.jpg',100,100); % seg = 7; 30 iters
%I = imread_ncut('jpg_images/00000037.jpg',100,100);
%I = imread_ncut('jpg_images/00000232.jpg',100,100);
I = imread_ncut('jpg_images/00000091.png',50,50);
%I = imread_ncut('jpg_images/00001223.png',100,100);

%% create synthetic image
%I = [0.5*ones(20, 10), ones(20, 10)];
%I = [0.25*ones(100, 25), 0.5*ones(100, 25), 0.75*ones(100, 25), ones(100, 25)];
%I = imnoise(I, 'gaussian', 0, 0.1); % add Gaussian noise

%% display the image
figure(1);clf; imagesc(I);colormap(gray);axis off;
%disp('This is the input image to segment, press Enter to continue...');
%pause;

%% compute the edges imageEdges, the similarity matrix W based on
%% Intervening Contours, the Ncut eigenvectors and discrete segmentation
nbSegments = 2;
disp('computing Ncut eigenvectors ...');
tic;
[SegLabel,NcutDiscrete,NcutEigenvectors,NcutEigenvalues,W,imageEdges]= NcutImage(I,nbSegments);
disp(['The computation took ' num2str(toc) ' seconds on the ' num2str(size(I,1)) 'x' num2str(size(I,2)) ' image']);


%% display the edges
figure(2);clf; imagesc(imageEdges); axis off
%disp('This is the edges computed, press Enter to continue...');
%pause;

%% display the segmentation
figure(3);clf
bw = edge(SegLabel,0.01);
J1=showmask(I,imdilate(bw,ones(1,1))); imagesc(J1);axis off
%disp('This is the segmentation, press Enter to continue...');
%pause;

% %% display Ncut eigenvectors
% figure(4);clf;set(gcf,'Position',[100,500,200*(nbSegments+1),200]);
% [nr,nc,nb] = size(I);
% for i=1:nbSegments
%     subplot(1,nbSegments,i);
%     imagesc(reshape(NcutEigenvectors(:,i) , nr,nc));axis('image');axis off;
% end
% disp('This is the Ncut eigenvectors...');
% disp('The demo is finished.');

