function [W, obj] = KernelPNMFeu(A, r, max_iter, check_step, W0)
% kernel Projective NMF based on EU-distance
% He Zhang, Sep. 2012
% Ref: Z.Yang and E.Oja: Linear and non-linear projective 
% nonnegative matrix factorization, Transactions on Neural Networks, IEEE 2010

n = size(A,1);
rand('seed', 0);
if ~exist('W0', 'var') || isempty(W0)
    W0 = rand(n,r);
end
W = W0;
for iter=1:max_iter
    AW = A*W;
    W = W .* AW ./(W*(W'*AW)+AW*(W'*W)+eps);
    W = max(W,eps);
    W = W / norm(W);
    if mod(iter, check_step)==0
        obj = trace(A)-2*trace(W'*A*W)+trace(W'*W*(W'*A*W));
        fprintf('KernelPNMFeu: iter=%d, obj=%6.5f\n', iter, obj);
    end
end

if nargout>1
    obj = trace(A)-2*trace(W'*A*W)+trace(W'*W*(W'*A*W));
end
