/* $Id: pythonparser.y,v 1.1 2006/05/31 15:29:40 aehyvari Exp $ */
%{
#define YYERROR_VERBOSE
%}

%start ROOT

%union {
char *val; /* For returning strings */
}
%token <val> START
%token <val> STOP
%token <val> CODE
%token CRLF
%%

ROOT:
    psh { }
;

psh:
    { /* empty */ }
  |
    CRLF { printf("\n"); }psh
  |
    CODE CRLF { printf("%s", $1); } psh
  |
    special psh
;

special:
    START CRLF incl STOP CRLF { getCode($1, $4); }
;

incl:
    { printf(""); }
  |
    CRLF incl
  |
    CODE CRLF incl { printf(""); }
;

%%

#include "pythonlex.h"
#include <fcntl.h>

getCode(char *name1, char *name2) {
    char *errst;
    int fd = 0;
    char *ibuff;
    off_t nbytes = 0;
    printf("### start[%s]\n", name1);
    if (strncmp(name1, name2, 255) == 0) {
        printf("# Including data from file %s\n", name1);
        fd = open(name1, O_RDONLY);
        if (fd > 0) {
            printf("# file opened\n");
            nbytes = lseek(fd, 0, SEEK_END);
            printf("# Reading %d bytes of data\n", nbytes);
            ibuff = (char *)malloc(nbytes+1);
            lseek(fd, 0, SEEK_SET);
            read(fd, ibuff, nbytes);
            ibuff[nbytes] = 0;
            printf("# Start of include\n");
//            printf("\\begin{verbose}%%\n");
            printf("%s\n", ibuff);
//            printf("\\end{verbose}%%\n");
            printf("# End of include\n");
        }
        else {
            yyerror("# couldn't open file. ");
        }
    }
    else {
        errst = (char *)malloc(600);
        snprintf(errst, 300, "# Unmatched include names: start[%s], stop[%s]",
                name1, name2);
        yyerror(errst);
        free(errst);
    }
    printf("### stop[%s]\n", name2);
}

yyerror(char *s) {
    printf("%s\n", s);
}
