#!/usr/bin/env zsh
#
# $Id: initsplitter.sh,v 1.4 2005/05/12 13:31:05 aehyvari Exp $
#
# This is a startup script for the splitter system. It WILL delete the
# work directories specified in the file config.py!
#

# Argument specifies the return value at which to exit

solverhost=channel

function cleanup {
    echo Killing localsolver
    ssh $solverhost "kill -HUP \`cat /tmp/localsolver.pid\`" |ssh $solverhost && echo Localsolver killed
    echo Fetching solver results
    scp $solverhost:/lhome/aehyvari/work/instrumentation/solverwrapper.ins \
        /lhome/aehyvari/work/instrumentation/solverwrapper.ins

    echo Killing SATjm
    kill `cat /tmp/satjm.pid` && echo SATjm killed

    echo Killing Splitter
    kill `cat /tmp/splitter.pid` && echo Splitter killed

    echo Killing Heuristic
    kill -HUP `cat /tmp/heuristic.pid` && echo Heuristic killed

    echo Killing Grid Sampler
    kill `cat /tmp/gridsampler.pid` && echo Grid Sampler killed

    echo Processing collected data
    ./timetree.py

    exit $1
}

TRAPINT() {
    echo "Shutting down"
    # This is sort of an exception, so return is 1
    cleanup 1
}

function printusage {
    echo "Usage: $1 cnf name"
    echo "  name is a unique identifier for the job"
    echo "  cnf is the problem description in dimacs cnf"
}

if [[ "x" == "x$1" ]] then
    printusage $0
    exit 1
fi

if [[ "x" == "x$2" ]] then
    printusage $0
    exit 1
fi

echo Initializing the run time environment

./initialize.py || exit 1

echo Saving job name to config
echo "jobdescr = '${1}'" > jobdescr
./pythonparser < config.py > config.py.1
mv config.py.1 config.py

# Output redirection!
echo Setting up Heuristic
sh -c 'echo $$ > /tmp/heuristic.pid; exec ./heuristic.py > heuristic.out 2> heuristic.err' &
echo Heuristic pid is `cat /tmp/heuristic.pid`

echo Setting up Splitter
sh -c 'echo $$ > /tmp/splitter.pid; exec ./splitter.py '$1' '$2'' &
echo Splitter pid is `cat /tmp/splitter.pid`

echo Setting up SATjm
sh -c 'echo $$ > /tmp/satjm.pid; exec ./satjm.py > satjm.out 2> satjm.err' &
echo SATjm pid is `cat /tmp/satjm.pid`

echo Setting up localsolver
ssh $solverhost "sh -c 'echo \$\$ > /tmp/localsolver.pid; cd sat/distributed_reasoning; exec ./solverwrapper.py > solverwrapper.out 2> solverwrapper.err '" &

echo localsolver pid is `ssh $solverhost cat /tmp/localsolver.pid`

echo Setting up grid sampler
sh -c 'echo $$ > /tmp/gridsampler.pid; exec ./gridsampler.py > /dev/null 2>/dev/null' &
echo Grid sampler pid is `cat /tmp/gridsampler.pid`

sleep 2

wait `cat /tmp/splitter.pid`

# Return is zero, the normal way to exit (we hope)
cleanup 0
