# $Id$

#globalsplit = {}
#globalproblem = {}
#globalvars = {}
#globallearned = {}
#globalsolution = {}
#globaltimeout = {}
#globalunsat = {}
#globalvars["reqjob"] = 0


from string import *
import re
from yappsrt import *

class SplitlangScanner(Scanner):
    patterns = [
        ('[ \t]+', re.compile('[ \t]+')),
        ('CMDSTART', re.compile('#')),
        ('COMMENT', re.compile('c')),
        ('CNFLINE', re.compile('[-+<>_a-zA-Z0-9\\(\\)= ]+')),
        ('LISTING', re.compile('#[ \t]*listing')),
        ('ENDLISTING', re.compile('#[ \t]*endlisting')),
        ('SPLIT', re.compile('#[ \t]*split')),
        ('ENDSPLIT', re.compile('#[ \t]*endsplit')),
        ('PROBLEM', re.compile('#[ \t]*problem')),
        ('ENDPROBLEM', re.compile('#[ \t]*endproblem')),
        ('SOLUTION', re.compile('#[ \t]*solution')),
        ('ENDSOLUTION', re.compile('#[ \t]*endsolution')),
        ('LEARNED', re.compile('#[ \t]*learned')),
        ('ENDLEARNED', re.compile('#[ \t]*endlearned')),
        ('TIMEOUT', re.compile('#[ \t]*timeout')),
        ('UNSAT', re.compile('#[ \t]*unsat')),
        ('REQJOB', re.compile('#[ \t]*reqjob')),
        ('BEGINB', re.compile('#[ \t]*begin')),
        ('ENDB', re.compile('#[ \t]*end')),
        ('NAME', re.compile("\\['[-_/\\.a-zA-Z0-9]+'[ ,0-9]*\\]")),
        ('FILE', re.compile('[^ \n\t]+')),
        ('LOCAL', re.compile('#[ \t]*local')),
        ('NUM', re.compile('[-+]?[0-9]+')),
        ('ENDL', re.compile('\n')),
    ]
    def __init__(self, str):
        Scanner.__init__(self,None,['[ \t]+'],str)

class Splitlang(Parser):
    def list(self):
        _token_ = self._peek('ENDL', 'LISTING')
        if _token_ == 'ENDL':
            ENDL = self._scan('ENDL')
            list = self.list()
        else:# == 'LISTING'
            LISTING = self._scan('LISTING')
            ENDL = self._scan('ENDL')
            self.globalsplit = {}
            self.localsplit = {}
            self.globalproblem = {}
            self.localproblem = {}
            self.globalvars = {}
            self.globalvars["reqjob"] = 0
            self.globallearned = {}
            self.locallearned = {}
            self.globalsolution = {}
            self.localsolution = {}
            self.globaltimeout = {}
            self.globalunsat = {}
            body = self.body()
            ENDLISTING = self._scan('ENDLISTING')

    def body(self):
        _token_ = self._peek('ENDLISTING', 'SPLIT', 'PROBLEM', 'REQJOB', 'LEARNED', 'TIMEOUT', 'UNSAT', 'SOLUTION')
        if _token_ == 'ENDLISTING':
            pass
        elif _token_ == 'SPLIT':
            split = self.split()
            body = self.body()
        elif _token_ == 'PROBLEM':
            problem = self.problem()
            body = self.body()
        elif _token_ == 'REQJOB':
            jobreq = self.jobreq()
            body = self.body()
        elif _token_ == 'LEARNED':
            learnblk = self.learnblk()
            body = self.body()
        elif _token_ == 'TIMEOUT':
            timeout = self.timeout()
            body = self.body()
        elif _token_ == 'UNSAT':
            unsat = self.unsat()
            body = self.body()
        else:# == 'SOLUTION'
            solutionblk = self.solutionblk()
            body = self.body()

    def split(self):
        SPLIT = self._scan('SPLIT')
        NAME = self._scan('NAME')
        self.globalsplit[NAME] = []
        self.localsplit[NAME] = []
        ENDL = self._scan('ENDL')
        splitlist = self.splitlist(NAME)
        ENDSPLIT = self._scan('ENDSPLIT')
        NAME = self._scan('NAME')
        ENDL = self._scan('ENDL')

    def splitlist(self, N):
        cnf = self.cnf()
        if type(cnf) == list: self.globalsplit[N].append(cnf)
        else: self.localsplit[N].append(cnf)
        splitrest = self.splitrest(N)

    def splitrest(self, N):
        _token_ = self._peek('BEGINB', 'LOCAL', 'ENDSPLIT')
        if _token_ == 'ENDSPLIT':
            pass
        else:# in ['BEGINB', 'LOCAL']
            cnf = self.cnf()
            if type(cnf) == list: self.globalsplit[N].append(cnf)
            else: self.localsplit[N].append(cnf)
            splitrest = self.splitrest(N)

    def learnblk(self):
        LEARNED = self._scan('LEARNED')
        NAME = self._scan('NAME')
        self.globallearned[NAME] = []
        self.locallearned[NAME] = []
        ENDL = self._scan('ENDL')
        learnlist = self.learnlist(NAME)
        ENDLEARNED = self._scan('ENDLEARNED')
        NAME = self._scan('NAME')
        ENDL = self._scan('ENDL')

    def learnlist(self, N):
        cnf = self.cnf()
        if type(cnf) == list: self.globallearned[N].append(cnf)
        else: self.locallearned[N].append(cnf)
        learnrest = self.learnrest(N)

    def learnrest(self, N):
        _token_ = self._peek('BEGINB', 'LOCAL', 'ENDLEARNED')
        if _token_ == 'ENDLEARNED':
            pass
        else:# in ['BEGINB', 'LOCAL']
            cnf = self.cnf()
            if type(cnf) == list: self.globallearned[N].append(cnf)
            else: self.locallearned[N].append(cnf)
            learnrest = self.learnrest(N)

    def solutionblk(self):
        SOLUTION = self._scan('SOLUTION')
        NAME = self._scan('NAME')
        self.globalsolution[NAME] = []
        self.localsolution[NAME] = []
        ENDL = self._scan('ENDL')
        solutionlist = self.solutionlist(NAME)
        ENDSOLUTION = self._scan('ENDSOLUTION')
        NAME = self._scan('NAME')
        ENDL = self._scan('ENDL')

    def solutionlist(self, N):
        cnf = self.cnf()
        if type(cnf) == list: self.globalsolution[N].append(cnf)
        else: self.localsolution[N].append(cnf)
        solutionrest = self.solutionrest(N)

    def solutionrest(self, N):
        _token_ = self._peek('BEGINB', 'LOCAL', 'ENDSOLUTION')
        if _token_ == 'ENDSOLUTION':
            pass
        else:# in ['BEGINB', 'LOCAL']
            cnf = self.cnf()
            if type(cnf) == list: self.globalsolution[N].append(cnf)
            else: self.localsolution[N].append(cnf)
            solutionrest = self.solutionrest(N)

    def problem(self):
        PROBLEM = self._scan('PROBLEM')
        NAME = self._scan('NAME')
        self.globalproblem[NAME] = []
        self.localproblem[NAME] = []
        ENDL = self._scan('ENDL')
        problemlist = self.problemlist(NAME)
        ENDPROBLEM = self._scan('ENDPROBLEM')
        NAME = self._scan('NAME')
        ENDL = self._scan('ENDL')

    def problemlist(self, N):
        cnf = self.cnf()
        if type(cnf) == list: self.globalproblem[N].append(cnf)
        else: self.localproblem[N].append(cnf)
        problemrest = self.problemrest(N)

    def problemrest(self, N):
        _token_ = self._peek('BEGINB', 'LOCAL', 'ENDPROBLEM')
        if _token_ == 'ENDPROBLEM':
            pass
        else:# in ['BEGINB', 'LOCAL']
            cnf = self.cnf()
            if type(cnf) == list: self.globalproblem[N].append(cnf)
            else: self.localproblem[N].append(cnf)
            problemrest = self.problemrest(N)

    def cnf(self):
        _token_ = self._peek('BEGINB', 'LOCAL')
        if _token_ == 'BEGINB':
            BEGINB = self._scan('BEGINB')
            ENDL = self._scan('ENDL')
            e = []
            while self._peek('CNFLINE', 'ENDB') == 'CNFLINE':
                CNFLINE = self._scan('CNFLINE')
                e.append(CNFLINE + "\n")
                ENDL = self._scan('ENDL')
            ENDB = self._scan('ENDB')
            ENDL = self._scan('ENDL')
            return e
        else:# == 'LOCAL'
            LOCAL = self._scan('LOCAL')
            FILE = self._scan('FILE')
            ENDL = self._scan('ENDL')
            return FILE

    def jobreq(self):
        REQJOB = self._scan('REQJOB')
        NUM = self._scan('NUM')
        ENDL = self._scan('ENDL')
        self.globalvars["reqjob"] += int(NUM)

    def unsat(self):
        UNSAT = self._scan('UNSAT')
        NAME = self._scan('NAME')
        ENDL = self._scan('ENDL')
        self.globalunsat[NAME] = True

    def timeout(self):
        TIMEOUT = self._scan('TIMEOUT')
        NAME = self._scan('NAME')
        ENDL = self._scan('ENDL')
        self.globaltimeout[NAME] = True


def parse(rule, text):
    P = Splitlang(SplitlangScanner(text))
    return wrap_error_reporter(P, rule)




# data = '''# listing
# # reqjob 10
# # reqjob -3
# # reqjob +2
# #endlisting
# '''

# print "parsing"
# parse('list', data)
# print "parsed"
# for key in globalsplit.keys():
#     print key, globalsplit[key]

# print globalvars["reqjob"]

