#
# $Id: jobutils.py,v 1.1 2006/05/31 14:33:41 aehyvari Exp $
#

import re
def tofilesysname(name):
    return name.replace("'", "").replace("[", "").replace("]", "").replace(" ", "").replace(",", "-").replace(".", "_")

"""Some utilities for handling jobs"""
class Job:
    """The description of a job

    Job consists of the clauses given explicitly and a possible file
    containing the base job"""

    def __init__(self, name, globals, locals):
        self.globals = globals
        self.locals = locals
        self.name = name
        self.fsname = tofilesysname(name)

    def tosplitlang(self):
        retstr = "# problem " + self.name + "\n"
        for gstr in self.globals:
            retstr = "".join([retstr, "# begin\n"])
            retstr = "".join([retstr, "".join(gstr)])
            retstr = "".join([retstr, "# end\n"])

        for lstr in self.locals:
            retstr = "".join([retstr, "# local " + lstr + "\n"])

        retstr = "".join([retstr, "# endproblem " + self.name + "\n"])
        return retstr

    def tostring(self):

        lines = []
        num_vars = 0

        startline = 0

        # For each global description we need to find the p -line, get
        # the variable number from it and extend the list with
        # everything that follows the p-line.
        for cnf in self.globals:
            for i in range(0, len(cnf)):
                if cnf[i][0] != 'p':
                        continue # Not yet the p cnf -line
                else:
                    startline = i
                    break # We have the p cnf -line

            mo = re.search("^p[ \t]cnf[ \t]([0-9]+)", cnf[i])

            num_vars = max(num_vars, int(mo.group(1)))

            lines.extend(cnf[startline+1:]) # tail can be empty

        for cnffile in self.locals:
            cnffd = open(cnffile, 'r')
            cnf = cnffd.readlines()
            startline = 0
            for i in range(0, len(cnf)):
                if cnf[i][0] != 'p':
                    continue
                else:
                    startline = i
                    break
            mo = re.search("^p[ \t]cnf[ \t]([0-9]+)", cnf[i])

            num_vars = max(num_vars, int(mo.group(1)))

            lines.extend(cnf[startline+1:])

        lines = "".join(["p cnf " + str(num_vars) + " " + \
            str(len(lines)) + "\n"] + lines)

        return lines

    def filesysname(self):
        return self.fsname + ".cnf"

