#!/usr/bin/env python
#
# $Id: initialize.py,v 1.1 2006/05/31 14:33:40 aehyvari Exp $
#

import os

"""Clear / create workdirs"""

class Initerror(Exception):
    def __init__(self, error):
        self.error = error
    def __str__(self):
        return self.error

# This is from python tutorial
def removeall(top):
    for root, dirs, files in os.walk(top, topdown=False):
        for name in files:
            os.remove(os.path.join(root, name))
        for name in dirs:
            os.rmdir(os.path.join(root, name))

def cleandir(top):
    """Given a path, make sure an empty directory with that path is
    created.

    First check the path exists. If it exists and is a directory, remove
    it and create a new empty directory by the same name. If it exists
    and is a file, unlink it and create a new directory by the same
    name. If it does not exist, create the full path to the point."""

    if (os.path.isdir(top)):
        removeall(top)
    elif (os.path.isfile(top)):
        os.unlink(top)
    else:
        try:
            os.stat(top)
            # It exists but is not a dir or file
            raise Initerror("Something strange in path " + top)
        except OSError, e:
            pass

    # Removeall does not delete the top directory, so it might be there.
    # Then there's no need to create it.
    if not os.path.isdir(top):
        os.makedirs(top)

from config import heurwork
from config import queuework
from config import localsolverwork
from config import instwork
from config import dlwork
from config import logdir

for directory in [heurwork, queuework, localsolverwork, instwork, \
        dlwork, logdir]:
    cleandir(directory)

