#
# $Id: cnflang.py,v 1.1 2006/05/31 14:33:40 aehyvari Exp $
#

import string

class Cnf:
    """Construct, given a list of strings in cnf-format, a cnf-object

    cnf stands for conjunctive normal form and is a dimacs standard, of
    some sort. See dimacs cnf"""
    clauses = []
    header_encountered = 0
    num_vars = 0
    num_cls = 0
    comments = []

    def toString(self):

        header = string.join(self.comments + ["p cnf " + str(self.num_vars) \
            + " " + str(self.num_cls) + "\n"], "")


        body = string.join(map(lambda x: string.join(map(str, x) + ["0"]) + "\n", self.clauses), "")

        return "".join([header] + [body])

    def __init__(self, instance):
        self.clauses = []
        self.comments = []
        literals = []
        for cl in instance:
            line = str(cl)
            k = 0
            token, k = self.get_token(line, k)
            # First character of the line
            if (token != 0):
                if token == "c":
                    self.comments.append(line)
                    continue

                elif token == "p":
                    assert(self.clauses == [])
                    assert(self.header_encountered == 0)
                    token, k = self.get_token(line, k)
                    if (token != "cnf"):
                        print "Format error, p cnf NumBar, NumCls"
                        return
                    token, k = self.get_token(line, k)
                    self.num_vars = int(token)
                    token, k = self.get_token(line, k)
                    self.num_cls = int(token)
                    self.header_encountered = 1
                    continue
                else:
                    lit = int(token)
                    assert(abs(lit) <= self.num_vars)
                    if lit != 0:
                        literals.append(lit)
                    else:
                        self.clauses.append(literals)
                        literals = []
            # Rest of the characters in a line describing a clause
            token, k = self.get_token(line, k)
            while (token != 0):
                lit = int(token)
                assert(abs(lit) <= self.num_vars)
                if lit != 0:
                    literals.append(lit)
                else:
                    self.clauses.append(literals)
                    literals = []
                token, k = self.get_token(line, k)

        if literals != []:
            print "Trailing literals without termination"
        if len(self.clauses) != self.num_cls:
            print "Warning: header and number of clauses do not match"

    def get_token(self, line, place):

        while ((line[place] == " ") or (line[place] == "\t")):
            place += 1

        token = ""

        while ((line[place] != " ") and (line[place] != "\t") and
            (line[place] != "\n")):
            token += line[place]
            place += 1

        if (token == ""):
            token = 0

        return token, place

    def addClause(self, clause):
        """add clauses to the problem afterwards.

        Clauses must not contain new variables (not checked)"""

        self.clauses.append(clause)
        self.num_cls += 1


