#!/usr/bin/env python
#
# $Id: solverwrapper.py,v 1.1 2006/05/31 14:30:13 aehyvari Exp $
#

"""Request a single job, read it, start a new solver for the work just
read. Wait until solver finishes, parse it's output and reply to the
splitter. Start again."""

import socket
import re
import splitlang
#import cnflang
import os
import popen2
import sys
import time
import signal
import select
import thread

import instrumentation


from config import localsolverlog
from config import localsolverloglevel

from config import localsolverport
from config import localsolverpath
from config import localsolverargs
from config import localsolverwork
from config import localsolverhost
from logger import Logger

logger = Logger(localsolverloglevel, localsolverlog)
logger.threadnames = {thread.get_ident(): "main"}

HOST = localsolverhost
RESPORT = localsolverport
solver = localsolverpath
solverargs = localsolverargs
WORKDIR = localsolverwork

starttime = time.time()

ress = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
realpid = 0

inst = instrumentation.Instrumenter('solverwrapper.ins')

def cleanup():
    ress.close()
    if realpid != 0:
        killp = popen2.Popen3("kill " + str(realpid))
        logger.log("Killing solver process " + str(realpid), 0)
        po.wait()
        logger.log("Killed solver process " + str(realpid), 0)
    else:
        logger.log("solver not running, not killing", 1)

def huphandler(num, stack):
    cleanup()
    sys.exit(0)

signal.signal(signal.SIGHUP, huphandler)

connected = False
while not connected:
    try:
        ress.connect((HOST, RESPORT))
        connected = True
    except socket.error:
        logger.log("Connection to " + HOST + " port " + str(RESPORT) +
            " failed. Trying again...", 2)
        time.sleep(2)

logger.log("Connected to local solving port", 2)

data = ""
done = False

try:
    while (True):
        # The input might contain a leftover stop at least in the following
        # scenario:
        # The solver stops naturally (e.g.) by finding a solution. Meanwhile
        # the queue sends the problem to the grid and signals this to the
        # supervisor, which sends a stop signal to solver (here). So we want
        # to read any stops away.
        # Note the state variable to get the log entry when receiving
        # really starts

        logger.log("Starting waiting for problem", 2)
        inst.start("prwait")
        bytesrcvd = False
        while not done:
            data = "".join([data, ress.recv(10240)])
            if bytesrcvd == False:
                logger.log("Received first bytes", 3)
                inst.stop("prwait")
                inst.start("prrecv")
                bytesrcvd = True

            mo = re.search("^#[ \t]*stop", data, re.M)
            if (mo):
                data = data[mo.end():]
                logger.log("An excess stop found. A solution was " +\
                    "found while the problem was sent to grid?", 3)
            mo = re.search("^#[ \t]*endlisting", data, re.M)
            if (mo):
                done = True
        inst.stop("prrecv")
        logger.log("File received", 2)
        listing = data[:mo.end()]
        logger.log("Parsing started (" + str(len(listing)) + " chars)", 3)
        inst.start("prparse")
        rv, P = splitlang.parse('list', listing)
        inst.stop("prparse")
        data = mo.string[mo.end():]
        logger.log("File parsed", 2)

        if (len(P.globalproblem.keys()) != 1):
            logger.log("Exactly one problem must be given", 0)
            os.system("exit 1")

        pname = P.globalproblem.keys()[0]
        cnflist = P.globalproblem[pname]

        lines = []
        num_vars = 0

        # Read all cnf:s from the cnf list
        inst.start("assemble", pname)
        for cnf in cnflist:
            startline = 0
            for i in range(0, len(cnf)):
                if cnf[i][0] != 'p':
                    continue # Not yet the p cnf -line
                else:
                    startline = i
                    break # We have the p cnf -line
            mo = re.search("^p[ \t]cnf[ \t]([0-9]+)", cnf[i])

            num_vars = max(num_vars, int(mo.group(1)))

            lines.extend(cnf[startline+1:]) # tail can be empty

        cnffilelist = P.localproblem[pname]

        for cnffile in cnffilelist:
            cnffd = open(cnffile, 'r')
            cnf = cnffd.readlines()
            startline = 0
            for i in range(0, len(cnf)):
                if cnf[i][0] != 'p':
                    continue
                else:
                    startline = i
                    break
            mo = re.search("^p[ \t]cnf[ \t]([0-9]+)", cnf[i])

            num_vars = max(num_vars, int(mo.group(1)))

            lines.extend(cnf[startline+1:])

        inst.stop("assemble")

        inst.start("construct", pname)
        pf = open(WORKDIR + "/problem.cnf", "w")
        pf.write("p cnf " + str(num_vars) + " " + str(len(lines)) + "\n")
        pf.writelines(lines)
        pf.close()
        inst.stop("construct")

        logger.log("Starting solver", 2)
        inst.start("solve", pname)
        # Slightly dirty. We get the pid of the real solver, because we now
        # we're using (ba)sh and $! gets us the most recent background pid.
        # After printing the pid, we stand waiting for the process to end.
        po = popen2.Popen3("nice -n 19 " + solver + " " + WORKDIR + "/problem.cnf " + solverargs + \
            " > " + WORKDIR + "/results & echo $!; wait")
        realpid = po.fromchild.readline().strip()
        po.fromchild.close()
        logger.log("Solver pid is " + str(realpid), 2)

        # The search must stop in two cases.
        # (i) the solver has stopped or
        # (ii) the server has requested a stop of solving
        # Otherwise we must try to read something from the socket.
        # If something was read, we test if it was the stop. If nothing is
        # waiting to be read, we must sleep for some time. If the stop was
        # requested, the process must be stopped (somehow...) and data must
        # be adjusted accordingly
        while (po.poll() == -1) and \
            (re.search("^#[ \t]*stop", data, re.M) == None):
            # Get the file descriptor for select
            logger.log("Still searching...", 3)
            input, output, err = select.select([ress.fileno()], [], [], 2.0)
            if input != []:
                data = "".join([data, ress.recv(10240)])

        if po.poll() != -1:
            # Case (i) above, "normal" exit
            logger.log("Solver finished normally", 2)
            pass
        else:
            # Case (ii) above
            mo = re.search("^#[ \t]*stop", data, re.M)
            pid = realpid
            killp = popen2.Popen3("kill -HUP " + str(pid))
            logger.log("Killing solver process " + str(pid), 2)
            po.wait()
            logger.log("Killed solver process " + str(pid), 2)
            data = data[mo.end():]

        inst.stop("solve")


        logger.log("Solver finished", 2)
        results = open(WORKDIR + "/results")
        lines = results.readlines()

        inst.start("collect", pname)

        mo = re.search("Total Run Time[ \t]*([0-9\.]*)", '\n'.join(lines))
        if mo:
            inst.setruntime(pname, float(mo.group(1)))
        else:
            logger.log("Error getting processor usage", 0)

        output = ""
        for line in lines:
            if (re.search("RESULT:[ \t]+ABORT[ \t]+:[ \t]+TIME OUT", line,
                    re.M)):
                output += "# timeout " + pname + "\n"
                logger.log("timeout", 2)
                break
            elif (re.search("^(-?[1-9][0-9]*[- 0-9]*)Random Seed Used",
                    line, re.M)):
                mo = re.search("^(-?[1-9][0-9]*[- 0-9]*)Random Seed Used",
                    line, re.M)
                num_vars = max(map(abs, map(int, mo.group(1).strip().split(" "))))
                output += "# solution " + pname + "\n"
                output += "# begin\n"
                output += "p cnf " + str(num_vars) + " 1\n"
                output += mo.group(1) + " 0\n"
                output += "# end\n"
                output += "# endsolution " + pname + "\n"
                logger.log("solution", 2)
                break
            elif (re.search("RESULT:[ \t]+UNSAT", line, re.M)):
                output += "# unsat " + pname + "\n"
                logger.log("unsat", 2)
                break

        # If there are no lines of output, or something strange appeared,
        # assume a timeout
        if len(output) == 0:
            output += "# timeout " + pname + "\n"
        inst.stop("collect")

        inst.start("send", pname)
        ress.send("# listing\n" + output + "# endlisting\n")
        inst.stop("send")

        inst.tofile()

        done = False
except socket.error, desc:
    logger.log("Connection failure: " + str(desc), 0)
    cleanup()


