#!/usr/bin/env python
#
# $Id: heuristic.py,v 1.2 2006/05/31 15:22:47 aehyvari Exp $
#

"""Read commands from the socket, construct a cnf-instance from
commands, give the instance to a heuristic, collect the splits thus
constructed, construct a response from them and send them back to
socket, start listening commands again"""

import socket
import re
import splitlang
import cnflang
import os
import popen2
import sys
import time
import signal
import thread
import select
import os.path

import instrumentation

from config import heuristicport
from config import resultport
from config import heurwork
from config import heurprog
from config import heuroutput
from config import heurargs
from config import heurlog
from config import heurloglevel

from logger import Logger

pidholder = [0]

def cleanup():
    inst.tofile()
    s.close()
    realpid = 0
    try:
        realpid = int(open("/tmp/hpicosat.pid").readline().strip())
    except IOError:
        pass

    if realpid != 0:
        killp = popen2.Popen3("kill " + str(realpid))
        logger.log("Killing heuristic process " + str(realpid), 0)
        killp.wait()
        logger.log("Killed heuristic process " + str(realpid), 0)
    else:
        logger.log("Heuristic not running, not killing", 1)

def huphandler(num, stack):
    time.sleep(2) # Chill out a bit, so that we can do a cleaner exit
    cleanup()
    sys.exit(0)

logger = Logger(heurloglevel, heurlog)
logger.threadnames = {}
logger.threadnames[thread.get_ident()] = "main"

signal.signal(signal.SIGHUP, huphandler)

starttime = time.time()

HOST = ""
PORT = heuristicport
RPORT = resultport
WORKDIR = heurwork


s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
# When we crash, don't wait until the TIME_WAIT
s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, True)

connected = False
while connected == False:
    try:
        s.bind((HOST, PORT))
        connected = True
    except socket.error, e:
        logger.log("Failed to bind to port " + str(PORT) + ", " + \
            str(e), 1)
        time.sleep(2)

s.listen(1)
conn, addr = s.accept()



inst = instrumentation.Instrumenter('heuristic.ins')

logger.log('Connected by' + str(addr), 0)


def main_loop():
    data = ""
    done = False
    try:
        while (True):
            # Read the problem in
            logger.log("Starting waiting for problem", 1)
            inst.start("prwait")
            # For instrumentation, see when the first bytes are received
            bytercv = False
            while not done:
                data = "".join([data, conn.recv(10240)])
                if bytercv == False:
                    logger.log('Received beginning of job', 1)
                    inst.stop("prwait")
                    inst.start("prrecv")
                    bytercv = True
                mo = re.search("^#[ \t]*endlisting", data, re.M)
                if (mo):
                    done = True
            inst.stop("prrecv")
            logger.log("Full job received", 1)
            listing = data[:mo.end()]

            logger.log("Parsing started (" + str(len(listing)) + \
                " chars)", 1)
            inst.start("prparse")
            rv, P = splitlang.parse('list', listing)
            inst.stop("prparse")
            logger.log("Job parsed", 1)
            data = mo.string[mo.end():]

            if (len(P.globalproblem.keys()) != 1):
                logger.log("Exactly one problem must be given", 1)
                os.system("exit 1")

            pname = P.globalproblem.keys()[0]

            cnflist = P.globalproblem[pname]

            filename = WORKDIR + "/problem.cnf"
            pf = open(filename, 'w')

            lines = []
            num_vars = 0

            inst.start("assemble", pname)
            for cnf in cnflist:
                startline = 0
                for i in range(0, len(cnf)):
                    if cnf[i][0] != 'p':
                        continue
                    else:
                        startline = i
                        break
                mo = re.search("^p[ \t]cnf[ \t]([0-9]+)", cnf[i])

                num_vars = max(num_vars, int(mo.group(1)))

                lines.extend(cnf[startline+1:])
            cnffilelist = P.localproblem[pname]

            for cnffile in cnffilelist:
                cnffd = open(cnffile, 'r')
                cnf = cnffd.readlines()
                startline = 0
                for i in range(0, len(cnf)):
                    if cnf[i][0] != 'p':
                        continue
                    else:
                        startline = i
                        break
                mo = re.search("^p[ \t]cnf[ \t]([0-9]+)", cnf[i])

                num_vars = max(num_vars, int(mo.group(1)))

                lines.extend(cnf[startline+1:])

            inst.stop("assemble")

            # Empty the work directory
            # (must not contain dirs)
            files = os.listdir(WORKDIR)
            for file in files:
                if file[0:4] == '.nfs':
                    continue
                os.remove(os.path.join(WORKDIR, file))

            filename = WORKDIR + "/problem.cnf"

            inst.start("construct", pname)
            pf = open(filename, 'w')
            pf.write("p cnf " + str(num_vars) + " " + str(len(lines)) + "\n")
            pf.writelines(lines)
            pf.close()
            inst.stop("construct")

            logger.log("Starting solver", 1)

            inst.start("splitinit", pname)
            # Use the same trick as in solverwrapper to get the pid
            po = popen2.Popen3("nice -n 19 " + heurprog + " " + filename + \
                " " + heurargs + " > " + WORKDIR + heuroutput + \
                " & echo $! | tee /tmp/hpicosat.pid; wait")
            pidholder[0] = int(po.fromchild.readline().strip())
            realpid = pidholder[0]
            po.fromchild.close()
            logger.log("Heuristic pid is " + str(realpid), 1)
            inst.stop("splitinit")

            # We expect to see
            # # start
            # # stop

            # Indicates if we have received the stop from splitter
            atend = False

            inst.start('splitrun', pname)

            time.sleep(10)      # Assert that we have some time for
                                # solving. Also the sighup-handler must
                                # have time to be installed
            done = False
            while not done:
                mo = re.search("^#[ \t]*stop.*\n", data, re.M)
                if (mo):
                    logger.log("Got stop from splitter", 1)
                    done = True
                elif (po.poll() != -1):
                    logger.log("Heuristic has stopped", 1)
                    done = True
                else:
                    polls = select.select([conn], [], [], 1)
                    if polls[0] != []:
                        data = "".join([data, conn.recv(1024)])

            inst.stop('splitrun')

            # Rewind to the end if we got stop from the splitter.
            # Otherwise we need to do this later, when the results have
            # been sent.
            if (mo):
                atend = True
                data = mo.string[mo.end():]

            # Send HUP to po so that it knows it can stop.
            inst.start('waitsplit', pname)
            while (po.poll() == -1):
                killpo = popen2.Popen3("kill -HUP " + str(realpid))
                killpo.fromchild.close()
                logger.log("Waiting for splitter to stop", 1)
                time.sleep(2)

            inst.stop('waitsplit')

            logger.log("Solver finished", 1)
            pidholder[0] = 0

            # See if picosat found a solution
            output = open(WORKDIR + heuroutput)
            lines = output.readlines()
            solutionline = -1
            logger.log("Start sending", 1)
            for i in range(0, len(lines)):
                if (lines[i] == "A Satisfiable Assignment is: \n"):
                    solutionline = i+1
                    break

            mo = re.search("Total Runtime[ \t]*([0-9][0-9\.]*)",
                lines[len(lines)-1])

            procuse = -1
            if mo:
                procuse = float(mo.group(1).strip())

            if procuse < 0:
                logger.log("Error in reading runtime", 0)
            else:
                inst.setruntime(pname, procuse)

            # Possibly empty set of constructed splits. If it is empty,
            # we have unsat or sat result in the end, and we send this
            # result to the result port of splitter.
            files = []

            inst.start("collect", pname)
            output = "# listing\n"


            if (solutionline >= 0):
                output += "# solution " + pname + "\n"
                output += "# begin\n"
                output += "p cnf " + str(num_vars) + " 1\n"
                # Remove the '+'-signs from the output
                logger.log(lines[solutionline], 1)
                output += " ".join(map(str, \
                    [int(lit) for lit in lines[solutionline].split("  ")\
                        if (lit != '' and lit != '\n')])) + " 0\n"
                output += "# end\n"
                output += "# endsolution " + pname + "\n"
            else:
                files = os.listdir(WORKDIR)
                files = filter(lambda x: x != "problem.cnf" and \
                    x != heuroutput, files)

                if files != []:
                    output += "# split " + pname + "\n"

                for name in files:
                    logger.log(name, 1)
                    if (name == "problem.cnf" or name == heuroutput or
                        name[0:4] == ".nfs"):
                        continue
                    output += "# begin\n"
                    fd = open(WORKDIR + name, 'r')
                    resultstr = fd.read()
                    output += resultstr
                    output += "# end\n"
                    os.unlink(WORKDIR + name)

                if files != []:
                    output += "# endsplit " + pname + "\n"
                else:
                    output += "# unsat " + pname + "\n"

            output += "# endlisting\n"
            inst.stop("collect")

            if (files == []):
                inst.start("rsend", pname)
                rsock = socket.socket()
                rsock.connect((HOST, RPORT))
                rsock.send(output)
                rsock.close()
                inst.stop("rsend")

            if not atend:
                # Now the results are sent but splitter still thinks we
                # are running. Wait for splitter to signal the stop.
                done = False
                while not done:
                    mo = re.search("^#[ \t]*stop.*\n", data, re.M)
                    if (mo):
                        logger.log("Got stop from splitter", 1)
                        done = True
                    else:
                        polls = select.select([conn], [], [], 1)
                        if polls[0] != []:
                            data = "".join([data, conn.recv(1024)])
                data = mo.string[mo.end():]
                atend = True

            inst.start("send", pname)
            conn.send(output)
            inst.stop("send")

            logger.log("Sending done", 1)
            logger.log("", 1)

            # Now we expect to see a new instance, so start again.
        #    logger("At end of the round, we've read the following string:")

        #    print data
            inst.tofile()
            done = False

    except socket.error, e:
        logger.log("Socket failure: " + str(e), 0)
        logger.log("Cleaning up", 0)
        cleanup()
        sys.exit(1)

main_loop()

