#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <unistd.h>
#include <fstream>
#include <string>


void wrapper (char ** argv) {

  if (!getenv ("GLOBUS_LOCATION")) {
    std::ifstream sysconf ("/etc/sysconfig/globus");
    std::string line;
    while (getline (sysconf, line)) {
      char * tmp = strdup (line.c_str());
      if (putenv (tmp) < 0) free (tmp);
    }
  }

  // don't overwrite
  setenv ("GLOBUS_LOCATION", DEFAULT_GLOBUS_LOCATION, 0);

  if ( (!getenv ("ARC_LOCATION")) && (!getenv ("NORDUGRID_LOCATION")) ) {
    std::ifstream sysconf ("/etc/sysconfig/nordugrid");
    std::string line;
    while (getline (sysconf, line)) {
      char * tmp = strdup (line.c_str());
      if (putenv (tmp) < 0) free (tmp);
    }
  }

  // don't overwrite
  {
    char* loc = getenv("ARC_LOCATION");
    if (!loc) loc = getenv("NORDUGRID_LOCATION");
    if (!loc) loc = DEFAULT_ARC_LOCATION;
    setenv ("ARC_LOCATION", loc, 1);
    setenv ("NORDUGRID_LOCATION", loc, 1);
  }

  char * tmp = getenv ("LD_LIBRARY_PATH");
  std::string libpath = tmp ? tmp : "";
  if (!libpath.empty()) libpath = libpath + ':';
  libpath = libpath + getenv ("GLOBUS_LOCATION") + "/lib:" +
    getenv ("ARC_LOCATION") + "/lib";

  setenv ("LD_LIBRARY_PATH", libpath.c_str(), 1);

  setenv ("ARC_ENVIRONMENT_SETUP", "", 1);

  execvp (argv[0], argv);
}
