#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <string>
#include <vector>
#include <unistd.h>
#include <stdio.h>

#include "Preferences.h"
#include "CertInfo.h"
#include "DateTime.h"
#include "MdsQuery.h"

#define __UI_LIBRARY__
#include "ui_downloader.h"

#include "ngui.h"


extern "C"
int ngcatxx (const std::vector <std::string> & jobs,
	     const std::vector <std::string> & joblists,
	     const std::vector <std::string> & clusterselect_,
	     const std::vector <std::string> & clusterreject_,
	     const std::vector <std::string> & status,
	     const bool all,
	     const int whichfile,
	     int timeout,
	     int debug,
	     const bool anonymous) {

  std::vector <std::string> clusterselect = ResolveAliases (clusterselect_);
  std::vector <std::string> clusterreject = ResolveAliases (clusterreject_);

  std::vector <std::string> jobids;
  std::vector <Cluster> clusterlist;

  int error = 0;
  ActivateGlobus();

  // setting defaults

  if (timeout == UNDEFINED) timeout = iGetEnv ("NGTIMEOUT");
  if (timeout == UNDEFINED) timeout = iGetDef ("NGTIMEOUT");
  if (timeout == UNDEFINED) timeout = DEFAULT_TIMEOUT;

  if (debug == UNDEFINED) debug = iGetEnv ("NGDEBUG");
  if (debug == UNDEFINED) debug = iGetDef ("NGDEBUG");
  if (debug == UNDEFINED) debug = 0;

  // get user info

  CertInfo user;
  if (!user) {
    error = 1;
    goto errorexit;
  }

  if (debug) {
    std::cout << "User subject name: " << user.GetSN() << std::endl;
    std::cout << "Remaining proxy lifetime: "
	      << Period (user.TimeLeft()) << std::endl;
  }

  // finding the information

  jobids = GetJobIDs (jobs, joblists, clusterselect, clusterreject, status,
		      all);

  if (all && jobids.empty()) {
    std::cout << "ngcat: No jobs" << std::endl;
    goto errorexit;
  }

  if (jobids.empty()) {
    std::cerr << "ngcat: no valid jobids given" << std::endl;
    std::cerr << "Use \"ngcat -help\" for help" << std::endl;
    error = 1;
    goto errorexit;
  }

  for (std::vector <std::string>::iterator vsi = jobids.begin();
       vsi != jobids.end(); vsi++) {
    int pos0 = 0;
    if (vsi->substr (0, 9) == "gsiftp://") pos0 = 9;
    int pos = vsi->find_first_of (":/", pos0);
    if (pos == std::string::npos) {
      std::cerr << "ngcat: invalid jobid: " << *vsi << std::endl;
      error = 1;
      continue;
    }
    std::string clustername = vsi->substr (pos0, pos - pos0);
    bool found = false;
    for (std::vector <Cluster>::iterator cli = clusterlist.begin();
	 !found && cli != clusterlist.end(); cli++)
      if (clustername == cli->GetName()) found = true;
    if (!found) clusterlist.push_back (clustername);
  }

  if (clusterlist.empty()) {
    std::cerr << "ngcat: no valid jobids given" << std::endl;
    error = 1;
    goto errorexit;
  }

  FindClusterInfo (clusterlist, Mds::JobManipulation, user.GetSNx(), anonymous,
		   timeout, debug);

  for (std::vector <std::string>::iterator vsi = jobids.begin();
       vsi != jobids.end(); vsi++) {

    Cluster * c = NULL;
    std::string file;
    std::string jobstatus;

    bool found = false;
    bool selected = false;

    for (std::vector <Cluster>::iterator cli = clusterlist.begin();
	 !found && cli != clusterlist.end(); cli++)
      for (std::vector <Queue>::iterator qli = cli->queues.begin();
	   !found && qli != cli->queues.end(); qli++)
	for (std::vector <Job>::iterator jli = qli->jobs.begin();
	     !found && jli != qli->jobs.end(); jli++)
	  if (*vsi == jli->GetId()) {
	    if (jli->IsStatus (status)) {
	      selected = true;
	      c = &*cli;
	      jobstatus = jli->GetStatus();
	      if (whichfile == STDOUT)
		file = jli->GetStdout();
	      else if (whichfile == STDERR)
		file = jli->GetStderr();
	      else if (whichfile == GMLOG)
		file = "errors";
	    }
	    found = true;
	  }

    if (!found) {
      std::cerr << "ngcat: no job with jobid " << *vsi << " found" << std::endl;
      error = 1;
      continue;
    }
    if (!selected)
      continue;
    if (jobstatus == "DELETED") {
      std::cerr << "ngcat: job " << *vsi << " has already been deleted" << std::endl;
      error = 1;
      continue;
    }
    if ((whichfile == STDOUT || whichfile == STDERR) &&
	(jobstatus == "ACCEPTING" || jobstatus == "ACCEPTED" ||
	 jobstatus == "PREPARING" || jobstatus == "PREPARED" ||
	 jobstatus == "INLRMS:Q")) {
      std::cerr << "ngcat: job " << *vsi << " has not started yet" << std::endl;
      error = 1;
      continue;
    }
    if (file.empty()) {
      std::cerr << "ngcat: cannot determine the name of the "
	   << ((whichfile == STDOUT) ? "stdout" :
	       ((whichfile == STDERR) ? "stderr" :
		((whichfile == GMLOG) ? "grid manager log directory" :
		 "ERROR")))
	   << " for " << *vsi << std::endl;
      error = 1;
      continue;
    }
    int pos = vsi->rfind ('/');
    if (pos == std::string::npos) {
      std::cerr << "ngcat: invalid jobid: " << *vsi << std::endl;
      error = 1;
      continue;
    }
    std::string shortid = vsi->substr (pos + 1);

    std::vector <std::string> filenames;

    filenames.push_back (file);

    int err = ui_downloader ((c->GetContact() +
			      (whichfile == GMLOG ? "/info/" : "/")
			      + shortid).c_str(), false,
			     ("/tmp/" + shortid).c_str(), filenames, true,
			     false, debug, timeout);

    if (err) {
      std::cerr << "ngcat: The "
	   << ((whichfile == STDOUT) ? "stdout" :
	       ((whichfile == STDERR) ? "stderr" :
		((whichfile == GMLOG) ? "grid manager error log" : "ERROR")))
	   << " of the job could not be found." << std::endl;
      std::cerr << "It either hasn't been created yet or it has been successfully moved to the" << std::endl;
      std::cerr << "location specified in the job's xrsl description." << std::endl;
      error = 1;
      continue;
    }

    system (("cat /tmp/" + shortid + '/' + file).c_str());
    remove (("/tmp/" + shortid + '/' + file).c_str());
    pos = file.rfind ('/');
    while (pos != std::string::npos) {
      rmdir (("/tmp/" + shortid + '/' + file.substr (0, pos)).c_str());
      pos = file.rfind ('/', pos - 1);
    }
    rmdir (("/tmp/" + shortid).c_str());
  }

 errorexit:
  DeactivateGlobus();
  return error;
}
