#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <map>
#include <limits.h>

#ifndef UI_UTILS
#define UI_UTILS

std::map <int, int> ParseStringToMap (const std::string & value);

std::map <long int, int> ParseFreeCpuStringToMap (const std::string & value);

std::map <std::string, std::string> ParseOptionString (const std::string & optstring);

bool GetBooleanOption (const std::map <std::string, std::string> & options,
		       const std::string & opt, bool * value);
// returns true if opt was found in options, in which case * value is set
// accordingly. Otherwise * value is unchanged

void RemoveDefaultPort (std::string & url);

std::string UnX509 (const std::string & escaped);

#endif
