#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "MdsQuery.h"
#include "Xrsl.h"
#include "RemoteFile.h"

#ifndef UI_TARGET
#define UI_TARGET

//class Cluster;
//class Queue;

class Target {

 public:
  Target();
  Target (Cluster * c, Queue * q);
  ~Target () {};
  bool operator! () const;
  bool valid() const;
  int CalculateNeededFileSizes (const int timeout);
  long long int GetNeededCacheSize () const;
  long long int GetNeededSessDirSize () const;
  long long int GetNeededTotalSize () const;
  long long int GetRemoteSize () const;
  long long int GetLocalSize () const;
  const Environment * FindEnvironment (const std::string & attr,
				       const EnvironmentTest & envtest) const;
  int Accept ();
  const std::string & GetArchitecture () const;
  int GetFrequency () const;
  int GetCpuTime (long int * time) const;
  int GetWallTime (long int * time) const;
  long int GetMaxCpuTime () const;
  // -1 is infinite -2 is error
  int GetTotalCpus () const;
  int GetNodeMemory () const;
  int GetQueued () const;
  Cluster * cluster;
  Queue * queue;
  Xrsl xrsl;
 private:
  RemoteFileQuery query;
  long long int neededcachesize;
  long long int neededsessdirsize;
  long long int remotesize;
  long long int localsize;
};

#endif
