#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <string>
#include <vector>
#include <map>

#include "LdapQuery.h"
#include "Environment.h"
#include "Giis.h"

#ifndef UI_MDSQUERY
#define UI_MDSQUERY

#ifndef UNDEFINED
#define UNDEFINED -1
#endif

#if __CYGWIN__ || hpux
#undef stdin
#undef stdout
#undef stderr
#endif


namespace Mds {
  enum Filter { ClusterInfo, JobInfo, JobSubmission, JobManipulation };
};


class Job {

 public:
  Job () {};  // Added because of Swig
  Job (const std::string & id_);
  ~Job () {};
  const std::string & GetId () const;
  const std::string & GetStatus () const;
  const std::string & GetName () const;
  const std::string & GetErrors() const;
  const std::string & GetStdout () const;
  const std::string & GetStderr () const;
  const std::string & GetRerunable () const;
  long int GetReqCpuTime () const;
  int GetCpuCount () const;
  void SetAttr (const std::string & attr, const std::string & value);
  void Print (std::ostream & s = std::cout) const;
  void PrintShort (std::ostream & s = std::cout) const;
  bool IsStatus (const std::vector <std::string> & stat);
 private:
  std::string id;
  std::string owner;
  std::string execcluster;
  std::string execqueue;
  std::string stdout;
  std::string stderr;
  std::string stdin;
  std::string gmlog;
  long int reqcputime;
  long int reqwalltime;
  std::string status;
  int queuerank;
  std::string comment;
  std::string submissionui;
  std::string submissiontime;
  long int usedcputime;
  long int usedwalltime;
  std::string erasetime;
  int usedmem;
  std::string errors;
  std::string jobname;
  std::vector <Environment> runtimeenv;
  int cpucount;
  std::vector <std::string> execnodes;
  std::string clientsoftware;
  std::string proxyexptime;
  std::string completiontime;
  int exitcode;
  std::string rerunable;
};


class Queue {

 public:
  Queue () {};   // Added because of Swig
  Queue (const std::string & name_);
  ~Queue () {};
  const std::string & GetName () const;
  const std::string & GetStatus () const;
  int GetRunning () const;
  int GetQueued () const;
  int GetMaxRunning () const;
  int GetMaxQueuable () const;
  long int GetMaxCpuTime () const;
  long int GetMinCpuTime () const;
  long int GetDefaultCpuTime () const;
  int GetTotalCpus () const;
  int GetNodeMemory () const;
  const std::string & GetArchitecture () const;
  int GetFrequency () const;
  int GetUserFreeCpus (long int seconds = 0) const;
  long long int GetUserDiskSpace () const;
  void ClaimUserDiskSpace (long long int);
  const Environment * FindEnvironment (const std::string & attr,
				       const EnvironmentTest & envtest) const;
  float GetBenchmark (const std::string & name) const;
  void SetAttr (const std::string & attr, const std::string & value);
  void Print (std::ostream & s = std::cout) const;
  void PrintShort (std::ostream & s = std::cout) const;
  void Accept (long int seconds, int count);
 private:
  std::string name;
  std::string status;
  int running;
  int queued;
  int maxrunning;
  int maxqueuable;
  int maxuserrun;
  long int maxcputime;
  long int mincputime;
  long int defaultcputime;
  std::string schedpolicy;
  int totalcpus;
  std::string nodecpu;
  int cpufreq;
  int nodemem;
  std::string arch;
  std::vector <Environment> opsys;
  int gridrunning;
  int gridqueued;
  std::string comment;
  std::vector <Environment> runtimeenv;
  std::vector <Environment> middleware;
  std::map <long int, int> userfreecpus;
  long long int userdiskspace;
  int userqueuelength;
  std::map <std::string, float> benchmarks;
  bool homogeneity;
 public:
  std::vector <Job> jobs;
};


class Cluster {

 public:
  Cluster () {};   // Added because of Swig
  Cluster (const std::string & name_);
  ~Cluster () {};
  const std::string & GetName () const;
  const std::string   GetLongName () const;
  const std::string & GetContact () const;
  const std::string & GetArchitecture () const;
  int GetFrequency () const;
  int GetNodeMemory () const;
  int GetTotalCpus () const;
  int GetQueued () const;
  long long int GetCacheFree () const;
  void ClaimCache (long long int size);
  long long int GetSessionDirFree () const;
  void ClaimSessionDir (long long int size);
  const Environment * FindEnvironment (const std::string & attr,
				       const EnvironmentTest & envtest) const;
  float GetBenchmark (const std::string & name) const;
  long int GetSessionDirLifetime () const;
  EnvVersion GetServerVersion () const;
  bool MatchLocalSe (const std::string & location) const;
  bool HaveNodeAccess (const std::string & attr) const;
  bool HaveKeys () const;
  void SetAttr (const std::string & attr, const std::string & value);
  void Print (std::ostream & s = std::cout) const;
  void PrintShort (std::ostream & s = std::cout) const;
  int Connect (const std::string & usersn, bool anonymous,
	       int timeout, int debug = 0);
  int Query (Mds::Filter mdsfilter, const std::string & usersn,
	     int timeout, int debug = 0);
  int Result (int timeout, int debug = 0);
  int Find (Mds::Filter mdsfilter, const std::string & usersn, bool anonymous,
	    int timeout, int debug = 0);
 private:
  std::string name;
  std::string alias;
  std::string contact;
  std::vector <std::string> support;
  std::string lrmstype;
  std::string lrmsversion;
  std::string lrmsconfig;
  std::string arch;
  std::vector <Environment> opsys;
  bool homogeneity;
  std::string nodecpu;
  int cpufreq;
  int nodemem;
  int totalcpus;
  std::map <int, int> cpudist;
  long long int sessiondirfree;
  long long int sessiondirtotal;
  long long int cachefree;
  long long int cachetotal;
  std::vector <Environment> runtimeenv;
  std::vector <std::string> localse;
  std::vector <Environment> middleware;
  int totaljobs;
  int usedcpus;
  int queuedjobs;
  std::string location;
  std::vector <std::string> owner;
  std::string issuer;
  std::vector <std::string> nodeaccess;
  std::string comment;
  std::string intcontact;
  std::map <std::string, float> benchmarks;
  long int sessiondirlifetime;
  LdapQuery ldap;
 public:
  std::vector <Queue> queues;
};


void FindClusterInfo (std::vector <Cluster> & clusterlist,
		      Mds::Filter mdsfilter,
		      const std::string & usersn,
		      bool anonymous,
		      int timeout,
		      int debug = 0);

void FindClusterInfo (Cluster & cluster,
		      Mds::Filter mdsfilter,
		      const std::string & usersn,
		      bool anonymous,
		      int timeout,
		      int debug = 0);

std::vector <Cluster> FindClusters (std::vector <Giis> giislist,
				    const std::string & usersn,
				    bool anonymous,
				    int timeout,
				    int debug = 0);

#endif
